% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ztils.R
\name{pca_data}
\alias{pca_data}
\title{Principal Component Analysis Data}
\usage{
pca_data(data, pcavars, scaled = FALSE)
}
\arguments{
\item{data}{The dataframe to add principal components to.}

\item{pcavars}{The variables to include in the principle component analysis}

\item{scaled}{A boolean (TRUE or FALSE) indicating if the
pcavars are already scaled}
}
\value{
A plot showing PC1 on the x axis, PC2 on the y axis,
colored by group, with vectors and labels showing the
individual pca variables.
}
\description{
This function uses a dataframe, PCA variables, and a scaled boolean to
generate a dataframe with principal components as columns.
}
\examples{
pca_data(iris, iris[,c(1:4)], FALSE)
}
