% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zfit-package.R
\docType{package}
\name{zfit}
\alias{zfit}
\alias{zfit-package}
\title{zfit: Fit Models in a Pipe}
\description{
Improve the usage of model fitting functions within a piped
work flow.
}
\details{
\code{zfit} makes it easier to use a piped workflow with functions that don’t
have the “correct” order of parameters (the first parameter of the
function does not match the object passing through the pipe).

The issue is especially prevalent with model fitting functions, such as
when passing and processing a \code{data.frame} (or \code{tibble}) before passing
them to \code{lm()} or similar functions. The pipe passes the data object
into the first parameter of the function, but the conventional
estimation functions expect a formula to be the first parameter.

This package addresses the issue with three functions that make it
trivial to construct a pipe-friendly version of any function:
\itemize{
\item \code{zfunction()} reorders the arguments of a function. Just pass the name
of a function, and the name of the parameter that should receive the
piped argument, and it returns a version of the function with that
parameter coming first.
\item \code{zfold()} creates a fold (a wrapper) around a function with the
reordered arguments. This is sometimes needed instead of a simple
reordering, for example for achieving correct S3 dispatch, and for
functions that report its name or other information in output.
\item \code{zfitter()} takes any estimation function with the standard format of
a \code{formula} and \code{data} parameter, and returns a version suitable for
us in pipes (with the \code{data} parameter coming first). Internally, it
simply calls the \code{zfold()} function to create a fold around the fitter
function.
}

The package also includes ready made wrappers around the most commonly
used estimation functions. \code{zlm()}and \code{zglm()} correspond to \code{lm()} and
\code{glm()}, and \code{zlogit()}, \code{zprobit()}, and \code{zpoisson()}, use \code{glm()} to
perform logistic or poisson regression within a pipe.

Finally, the package includes the \code{zprint()} function, which is intended
to simplify the printing of derived results, such as \code{summary()}, within
the pipe, without affecting the modeling result itself.
}
\seealso{
\itemize{
\item \link{zlm} is the wrapper \code{lm}, probably the most common fitting
function. The help file for this function includes several
usage examples.
\item \link{zglm} is a wrapper for \code{glm}, to fit generalized
linear models.
\item \link{zprint} is helpful for printing a \code{summary} of a model,
but assigning the evaluated model to a variable
}
}
