% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zeroEQpart.R
\docType{package}
\name{zeroEQpart-package}
\alias{zeroEQpart}
\alias{zeroEQpart-package}
\title{Zero Order vs (Semi) Partial Correlation Test and CI}
\description{
Calculate the statistical significance of a zero order
  correlation being equal to a partial or semi-partial correlation using
  the bias-corrected and accelerated bootstrap method from "An Introduction
  to the Bootstrap" Efron (1983) <0-412-04231-2>. Confidence intervals for
  the parameter (zero order minus partial) can also be determined.
}
\section{pzcor}{
 The \code{pzcor} function tests one of the following null
  hypotheses: \itemize{
                  \item{\eqn{\rho.xy - \rho.xy.z = 0} (default)}
                  \item{\eqn{\rho.xy - \rho.xy.z \ge 0}}
                  \item{ \eqn{\rho.xy - \rho.xy.z \le 0}}
                  }
  See \code{\link{pzcor}} for details.
}

\section{pzconf}{
 The \code{pzconf} function computes confidence intervals
  for the parameter: \eqn{\rho.xy - \rho.xy.z}. To be used with
  \code{pzcor}. See \code{\link{pzconf}} for details.
}

\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/djrichar92/zeroEQpart}
  \item Report bugs at \url{https://github.com/djrichar92/zeroEQpart/issues}
}

}
\author{
\strong{Maintainer}: Dan Richard \email{djrichar@ualberta.ca}

Other contributors:
\itemize{
  \item Karen Buro \email{BuroK@macewan.ca} [contributor]
  \item Wanhua Su \email{SuW3@macewan.ca} [contributor]
}

}
