% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pzcor.R
\name{pzcor}
\alias{pzcor}
\title{Test for Equal Zero Order and (Semi) Partial Correlation}
\usage{
pzcor(x, y, z, semi = FALSE, k = 1000, method = "pearson",
  test = "eq")
}
\arguments{
\item{x}{a numeric vector.}

\item{y}{a numeric vector.}

\item{z}{a numeric vector (data.frame, matrix, etc.)}

\item{semi}{logical. If \code{TRUE}, then the semi-partial correlation between
\code{x} and \code{y} given \code{z} is used. If \code{FALSE} (default),
then the partial correlation between \code{x} given \code{z} and \code{y}
given \code{z} is used.}

\item{k}{the number of bootstrap samples taken (default is 1000).}

\item{method}{a character string indicating which correlation
coefficient is to be computed. One of "pearson" (default), "kendall", or
"spearman" can be abbreviated.}

\item{test}{character string denoting the null hypothesis to be tested. Can
be one of the three:
\itemize{
    \item{\code{'eq'} tests  \eqn{\rho.xy - \rho.xy.z = 0} (default)}
    \item{\code{'gt'} tests  \eqn{\rho.xy - \rho.xy.z \ge 0}}
    \item{\code{'lt'} tests  \eqn{\rho.xy - \rho.xy.z \le 0}} }}
}
\value{
\item{acceleration}{the acceleration used for the BCa method.}

 \item{alpha}{the proportion of the bootstrapped distribution below zero.}

 \item{bias}{the bias used for the BCa method.}

 \item{call}{shows the function call.}

 \item{difference}{calculated from the data. Same as \code{p.xy - p.xy.z}.}

 \item{distribution}{the estimated distribution of the difference as
 determined through bootstrapping.}

 \item{k_eff}{the number of successful bootstrap samples. Less than or equal
 to \code{k}.}

 \item{method}{the method of correlation used.}

 \item{p.value}{significance level of the test.}

 \item{p.xy}{Zero order correlation between \code{x} and \code{y}.}

 \item{p.xy.z}{(semi) partial correlation between \code{x} and \code{y} while
 accounting for \code{z}.}

 \item{semi}{logical. If \code{TRUE}, \code{p.xy.z} is the semi-partial
 correlation. Otherwise \code{p.xy.z} is the partial correlation.}

 \item{test}{shows the type of test performed.}
}
\description{
Compute a bootstrap test to determine whether zero order
 correlation is equal to partial or semi-partial correlation.
}
\details{
Uses the bias-corrected and accelerated (BCa) bootstrap method to
 test if the difference \eqn{\rho.xy - \rho.xy.z} is equal to, above, or
 below zero where \eqn{\rho.xy} is the zero order correlation between
 variables \eqn{x} and \eqn{y}, and \eqn{\rho.xy.z} is the (semi) partial
 correlation between the respective variables after partialing out
 variables represented by \eqn{z}.

 If the bootstrap distribution of
 \eqn{\rho.xy - \rho.xy.z} is strictly above or below zero, then
 the p-value provided is the most extreme value that can be determined
 by the test. In the case of highly correlated variables, the
 covariance matrix may be singular which will lead to \code{k_eff} being
 less than \code{k} (as \eqn{\rho.xy - \rho.xy.z} would not be computed).
}
\examples{
require(graphics)
require(MASS)
# data
set.seed(1111)
mu <- rep(0,4)
Sigma <- matrix(.2, nrow=4, ncol=4) + diag(4)*.8
data <- mvrnorm(n=100, mu=mu, Sigma=Sigma)

# p.(1,2) = p.(1,2)|(3,4) test
test <- pzcor(data[,1], data[,2], data[,c(3,4)], k = 1000, semi = FALSE,
              test = 'eq')
hist(test$distribution)
test
}
\seealso{
\code{\link{pzconf}}
}
