% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{open_zarr}
\alias{open_zarr}
\title{Open a Zarr store}
\usage{
open_zarr(location, read_only = FALSE)
}
\arguments{
\item{location}{Character string that indicates a location on a file system
or a HTTP server where the Zarr store is to be found. The character string
may contain UTF-8 characters and/or use a file URI format.}

\item{read_only}{Optional. Logical that indicates if the store is to be
opened in read-only mode. Default is \code{FALSE} for a local file system store,
\code{TRUE} otherwise.}
}
\value{
A \link{zarr} object.
}
\description{
This function opens a Zarr object, connected to a store located on the local
file system or on a remote server using the HTTP protocol. The Zarr object
can be either v.2 or v.3.
}
\examples{
fn <- system.file("extdata", "africa.zarr", package = "zarr")
africa <- open_zarr(fn)
africa
}
