% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perLog.R
\name{perLog}
\alias{perLog}
\title{Test of differences in group means for compositional data}
\usage{
perLog(X, groups = NULL, p = "auto", alpha = 0.05, R = 1000,
          posthoc.g = FALSE, posthoc.lr = FALSE, mAdj = "BH")
}
\arguments{
\item{X}{Compositional data set (\code{\link{matrix}} or \code{\link{data.frame}} class).}

\item{groups}{Factor variable indicating the grouping structure. If NULL (default), any zero patterns in the data will be used as internal grouping factor.

Note that if a grouping factor is set by the user, then any zeros in the data must be previously dealt with, e.g. by imputation.}

\item{p}{Power parameter selected in overall dissimilarity test statistic, either automatically (default = "auto") or manually fixed.}

\item{alpha}{Significance level parameter (default = 0.05).}

\item{R}{Number of permutation resamples (default = 1000).}

\item{posthoc.g}{Logical. If TRUE, performs post-hoc analysis for pairs of groups (default = FALSE).}

\item{posthoc.lr}{Logical. If TRUE, performs post-hoc analysis for logratios (default = FALSE).}

\item{mAdj}{Adjustment of p-values for multiple post-hoc testing (see \code{\link{p.adjust}}). Default is Benjamini and Hochberg's FDR method (default = "BH").}
}
\value{
A list object of class "perLog.output" containing summaries of results:
\item{disOv}{Overall dissimilarity test statistic.}
\item{pvalOv}{Overall permutation p-value.}
\item{p}{Power parameter used in overall dissimilarity test statistic.}
\item{posthoc.groups}{If `posthoc.g = TRUE` and the main test is significant, results of the post-hoc analysis for pairs of groups.}
\item{posthoc.logratios}{If `posthoc.lr = TRUE` and the main test is significant, results of the post-hoc analysis for pairwise logratios.}
\item{wts}{Welch's t-statistic.}
\item{disEl}{Pairwise logratio elemental dissimilarity.}
\item{rcElBg}{Relative contribution of elemental dissimilarity to between-group dissimilarity.}
\item{rcElOv}{Relative contribution of elemental dissimilarity to overall dissimilarity.}
\item{pvalElAdj}{Adjusted p-value in post-hoc comparison.}
\item{parts0}{If `groups = NULL`, list containing original names of zero parts in the respective zero patterns.}
}
\description{
A nonparametric permutation test to assess the hypothesis of equality of means between subsets of observations according to an externally or internally defined factor variable. If any, zero patterns are considered as default internal grouping factor.
}
\details{
The test relies on the unique pairwise logratios between parts of the given composition. It assesses whether the observed overall dissimilarity is significantly different from that expected under the null hypothesis of equal group means. If so, it can perform post-hoc analyses by pairs of groups and pairwise logratios, evaluating their relative contributions to dissimilarity at group and overall levels. The p-values in post-hoc testing are adjusted for multiple comparisons using the specified method.
In the case of internal grouping defined by zero patterns, strings of binary codes are used to label each pattern in the output, with 0 indicating no zero part and 1 indicating zero part.

The power parameter p can be either automatically selected or manually fixed. For automatic selection, a simple conservative strategy is implemented starting with p = 10, as a liberal reference, and then successively setting p = \{2, 3, ..., 9\} until less significant differences are no longer obtained at the overall and group comparison levels.
}
\examples{
# Load the Water data set 
data(Water)
# Visualise zero patterns and select the first three for illustration
tmp <- zPatterns(Water, label = 0)
Water2 <- Water[tmp \%in\% c(1,2,3),]
# Test overall differences by zero pattern on the selected data set
zPatterns(Water2, label = 0)
perLog(Water2)
}
\references{
Štefelová N, Palarea-Albaladejo J, Martín-Fernández JA. A permutation test of differences between externally or internally defined groupings in compositional data sets. Statistical Methods in Medical Research. 2026;0(0). <doi:10.1177/09622802251413737>
}
\seealso{
\code{\link{zPatterns}}
}
