% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xxhash.R
\name{xxhash_file}
\alias{xxhash_file}
\title{Calculate the hash of a file}
\usage{
xxhash_file(file, algo = "xxh128", as_raw = FALSE)
}
\arguments{
\item{file}{filename}

\item{algo}{Select the specific xxhash algorithm. Default: 'xxh128'.
(the latest algorithm in the xxhash family)
Valid values: 'xxh32', 'xxh64', 'xxh128', 'xxh3'}

\item{as_raw}{Return the hash as a raw vector of bytes instead of string?
Default: FALSE.  If TRUE, then the raw bytes are returned in big-endian
order - which is what \code{xxHash} considers the \emph{canonical} form.}
}
\value{
String representation of hash. If \code{as_raw = TRUE} then a 
        raw vector is returned instead.
}
\description{
Calculate the hash of a file
}
\examples{
filename <- system.file('DESCRIPTION', package = 'base', mustWork = TRUE)
xxhash_file(filename)
}
