% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xml2relational.r
\name{savetofiles}
\alias{savetofiles}
\title{Saving the relational data}
\usage{
savetofiles(ldf, dir, sep = ",", dec = ".")
}
\arguments{
\item{ldf}{A \strong{l}ist of \strong{d}ata\strong{f}rames created by
\code{\link{toRelational}()} (the data tables transformed from XML to a
relational schema).#' @param dir Directory where the files will be stored.
Default is the current working directory.}

\item{dir}{The directory to save the CSV files in. Per default the working directory.}

\item{sep}{Character symbol to separate fields in the CSV fil, comma by
default.}

\item{dec}{Decimal separator used for numeric fields in the CSV file, point
by default.}
}
\value{
No return vaue.
}
\description{
Saves a list of dataframes created from an XML source with
  \code{\link{toRelational}()} to CSV files, one file per dataframe (i.e.
  table in the relational data model). File names are identical to the
  dataframe/table names.
}
\examples{
# Find path to custmers.xml example file in package directory
path <- system.file("", "customers.xml", package = "xml2relational")
db <- toRelational(path)

savetofiles(db, dir = tempdir())


}
\seealso{
Other xml2relational: 
\code{\link{getCreateSQL}()},
\code{\link{getInsertSQL}()},
\code{\link{toRelational}()}
}
\concept{xml2relational}
