% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xlr_table.R
\name{xlr_table}
\alias{xlr_table}
\alias{is_xlr_table}
\alias{as_xlr_table}
\title{\code{xlr_table} object}
\usage{
xlr_table(x, title = character(), footnote = character())

is_xlr_table(x)

as_xlr_table(x, title = character(), footnote = character())
}
\arguments{
\item{x}{a data object
\itemize{
\item for \code{xlr_table()} : a \code{data.frame}, or \code{tibble}. See notes for further details.
\item for \code{is_xlr_table()} : An object
\item for \code{as_xlr_table()} a \code{data.frame}, or \code{tibble}.
}}

\item{title}{a string that is the title}

\item{footnote}{a string that is the footnote}
}
\value{
a \code{xlr_table} S3 class
}
\description{
Create a \code{xlr_table} S3 object. This is used to create an object that stores
formatting information, as well as a title and footnote. This objects makes it
easy to convert to an \code{Excel} sheet, using \code{\link[=write_xlsx]{write_xlsx()}}.
To edit underlying formatting options use \code{\link[=update_theme]{update_theme()}}.

A number of \code{dplyr} methods have been implemented for \code{xlr_table}, these
include \code{mutate}, \code{summarise}, \code{select}, etc. This means you can use these
functions on a \code{xlr_table}, without losing the \code{xlr_table} attributes. You
can check if the \code{dplyr} function is supported by checking the documentation
of the function. Currently, it is not possible to use \code{group_by} and a \code{xlr_table},
as this would require the implementation of a new class.

You can convert a table back to a data.frame with base type with \code{\link[=as_base_r]{as_base_r()}}.
}
\examples{
\dontshow{
  oldWd <- setwd(tempdir())
}

library(xlr)
library(dplyr)
# Create a xlr_table, we set the footnotes and the title
# It converts to the xlr types by default
x <- xlr_table(mtcars,
                title = "mtcars is a fun data set",
                footnote = "mtcars is a data set that comes with base R")
# The title and the footnote print to console
x
# You can use mutate and summarise with xlr_tables and they are preserved
x |>
  summarise(mean_mpg = sum(mpg))
# Rename a column
x |>
  rename(new_name = mpg)
# When you want to change how elements of the table look when written using
# write_xlsx, you can update it with update them
x <- x |>
  # make the font bigger
  update_theme(title_format = xlr_format(font_size = 14))
# you must write it in order to see the formatting changes
write_xlsx(x,
             "example.xlsx",
             "A example sheet",
             TOC = FALSE)

\dontshow{
  # restore wd
  setwd(oldWd)
}
}
\seealso{
\code{\link[=update_theme]{update_theme()}}, \code{\link[=as_base_r]{as_base_r()}}
}
