% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_xlsx.R
\name{write_xlsx}
\alias{write_xlsx}
\title{Write a \code{xlr_table}, \code{data.frame}, or \code{tibble} to an .xlsx (\code{Excel}) file}
\usage{
write_xlsx(
  x,
  file,
  sheet_name = NULL,
  overwrite = FALSE,
  append = TRUE,
  TOC = FALSE,
  TOC_title = NA_character_,
  overwrite_sheets = TRUE,
  excel_data_table = TRUE
)
}
\arguments{
\item{x}{a single or \code{list} of types \code{xlr_table}, \code{data.frame}, or \code{tibble}.}

\item{file}{character. A valid file path.}

\item{sheet_name}{a sheet name (optional). Only valid for when you pass a single
object to \code{x}.}

\item{overwrite}{logical. Whether to overwrite the file/worksheet or not.}

\item{append}{logical. Whether or not to append a worksheet to an existing
file.}

\item{TOC}{logical. Whether to create a table of contents with
the document. Works only when you pass a \code{list} to \code{x}. To add a table of
contents to an existing file, use \code{\link[=create_table_of_contents]{create_table_of_contents()}}.}

\item{TOC_title}{character. To specify the table of contents title (optional).}

\item{overwrite_sheets}{logical. Whether to overwrite existing sheets in a
file.}

\item{excel_data_table}{logical. Whether to save the data as an \code{Excel} table
in the worksheet. These are more accessible than data in the sheet.}
}
\value{
None
}
\description{
This function writes \code{xlr_table}, \code{data.frame}, or \code{tibble} to an .xlsx
(\code{Excel} file). Like \link[openxlsx]{write.xlsx} you can also write a \code{list} of
\code{xlr_table}'s, \code{data.frame}'s, and \code{tibbles}'s to the one file.
The main use of this function is that it uses the formatting in a \code{xlr_table}
when it writes to the \code{Excel} sheet. See \link{xlr_table} for more information.
}
\examples{
\dontshow{
  oldWd <- setwd(tempdir())
}
library(xlr)
library(tibble)
# we can write a data.frame or tibble with write_xlsx
example_tibble <- tibble(example = c(1:100))

write_xlsx(mtcars,
           "example_file.xlsx",
           sheet_name = "Example sheet")

# you must specify a sheet name
write_xlsx(example_tibble,
           "example_file.xlsx",
           sheet_name = "Example sheet")

# You can write a xlr_table.
# When you write a xlr_table you can specify the formatting as well as titles
# and footnotes.
example_xlr_table <- xlr_table(mtcars,
                                 "This is a title",
                                 "This is a footnote")

write_xlsx(example_xlr_table,
           "example_file.xlsx",
           "Example sheet")

# like openxlsx, you can also pass a list
table_list <- list("Sheet name 1" = xlr_table(mtcars,
                                               "This is a title",
                                               "This is a footnote"),
                   "Sheet name 2" = xlr_table(mtcars,
                                              "This is a title too",
                                              "This is a footnote as well"))

write_xlsx(table_list,
           "example_file.xlsx")
\dontshow{
  # restore wd
  setwd(oldWd)
}
}
