% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_multiple_response_table.R
\name{build_mtable}
\alias{build_mtable}
\title{Summarise a multiple response table}
\usage{
build_mtable(
  x,
  mcols,
  cols = NULL,
  table_title = "",
  use_questions = FALSE,
  use_NA = FALSE,
  wt = NULL,
  footnote = ""
)
}
\arguments{
\item{x}{a data frame or tidy object.}

\item{mcols}{the column(s) that are multiple response questions. See
the \code{Details} for more details of how these columns should be structured.}

\item{cols}{the column(s) that we want to calculate the sum/percentage of and
the multiple response question.}

\item{table_title}{the title of the table sheet}

\item{use_questions}{if the data has column labels (was a imported .sav)
file, convert the column label to a footnote with the question.}

\item{use_NA}{logical. whether to include \code{NA} values in the table. For more complicated
\code{NA} processing post creation, we recommend using filter.}

\item{wt}{Specify a weighting variable, if \code{NULL} no weight is applied.}

\item{footnote}{optional parameter to pass a custom footnote to the question,
this parameter overwrites \code{use_questions}.}
}
\value{
a \code{xlr_table} object. Use \link{write_xlsx} to write to an \code{Excel} file.
See \link{xlr_table} for more information.
}
\description{
This function can take one or two multiple response responses and generate
a summary table with them. You can also cut these columns by other categorical
columns by specify the cols parameter.
}
\details{
A multiple response response is a series of columns with a single unique
response that stores survey data where a respondent may have chosen
multiple options. This function works if this data is stored in a \strong{wide}
format. To have a valid multiple response column all the columns should
start with the same text, and each contain a unique value. That is it
has the form:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{ data.frame(multi_col_1 = c(1,NA,1),
           multi_col_2 = c(1,1,1),
           multi_col_3 = c(NA,NA,1)
 )
#>   multi_col_1 multi_col_2 multi_col_3
#> 1           1           1          NA
#> 2          NA           1          NA
#> 3           1           1           1
}\if{html}{\out{</div>}}

This is how popular survey platforms such as Qualtrics output this data type. If
your data is long, you will need to pivot the data before hand, we recommend
using \link[tidyr]{pivot_wider}.

By default this function converts \link[haven]{labelled} to a \link{xlr_vector}
by default (and underlying it is a \code{character()} type).

This function and its family (\link{build_table}, \link{build_qtable}) is designed to
work with data with columns of type \code{haven::labelled},
which is the default format of data read with \code{haven::read_sav}/has the format
of \code{.sav}. \code{.sav} is the default file function type of data from \code{SPSS} and
can be exported from popular survey providers such as Qualtrics. When you
read in data with \code{haven::read_sav} it imports data with the questions,
labels for the response options etc.

See \link[haven]{labelled} and \link[haven]{read_sav} if you would like more
details on the importing type.
}
\examples{
library(xlr)
library(dplyr)

# You can use this function to calculate the number of people that have
# responded to the question `What is your favourite colour`
build_mtable(clothes_opinions,
             "Q2",
             table_title = "What is your favourite colour?")

# The function also lets you to see the number of NA questions (this is
# where someone doesn't answer any option)
build_mtable(clothes_opinions,
             "Q2",
             table_title = "What is your favourite colour?",
             use_NA = TRUE)

# You can also cut all questions in the multiple response functions by another
# column
build_mtable(clothes_opinions,
             "Q2",
             gender2,
             table_title = "Your favourite colour by gender")

# By setting `use_questions=TRUE` then the footnote will be the questions
# labels. This is useful to see what the question is.
# The function will try to pull out this based on the question label, and
# will manipulate try and get the correct label.
build_mtable(clothes_opinions,
             "Q2",
             gender2,
             table_title = "Your favourite colour by gender",
             use_questions = TRUE)

# It is common for your data to include 'other' responses in a multiple
# response column. You should remove the column before running build_mtable
clothes_opinions |>
  select(-Q3_other) |>
  build_mtable("Q3")

# You can also specify up to a maxium of two different multiple response
# columns.
clothes_opinions |>
  select(-Q3_other) |>
  build_mtable(c("Q2", "Q3"))

# These cam also be cut by other columns.
clothes_opinions |>
  select(-Q3_other) |>
  build_mtable(c("Q2", "Q3"),
               gender2)

# This function also supports weights and manual footnotes
clothes_opinions |>
  select(-Q3_other) |>
  build_mtable(c("Q2", "Q3"),
               gender2,
               wt = weight,
               footnote = "This is an example footnote.")
}
