% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xgx_stat_ci.R
\name{xgx_conf_int}
\alias{xgx_conf_int}
\title{\code{xgx_conf_int} returns a dataframe with mean +/- confidence intervals}
\usage{
xgx_conf_int(y, conf_level = 0.95, distribution = "normal")
}
\arguments{
\item{y}{data to compute confidence interval of}

\item{conf_level}{The percentile for the confidence interval (should fall 
between 0 and 1). The default is 0.95, which corresponds to a 95 percent 
confidence interval.}

\item{distribution}{The distribution which the data follow, used for 
calculating confidence intervals. The options are "normal", "lognormal", 
and "binomial". The "normal" option will use the Student t Distribution 
to calculate confidence intervals, the "lognormal" option will transform 
data to the log space first. The "binomial" option will use the
\code{\link[binom:binom.confint]{binom.exact}} function to calculate the
confidence 
intervals. Note: binomial data must be numeric and contain only 1's and 0's.}
}
\value{
data.frame
}
\description{
\code{xgx_conf_int} returns a dataframe with mean +/- confidence intervals
}
\examples{
# default settings for normally distributed data, 95\% confidence interval,  
data <- data.frame(x = rep(c(1, 2, 3), each = 20),
                   y = rep(c(1, 2, 3), each = 20) + stats::rnorm(60),
                   group = rep(1:3, 20))
xgx_conf_int(data$y)
  
}
