% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/newTSP.R
\docType{data}
\name{lau15}
\alias{lau15}
\title{The problem environment \code{lau15} for a traveling salesman problem.}
\format{
An object of class \code{list} of length 14.
}
\usage{
lau15
}
\description{
15 abstract cities for which a traveling salesman solution is sought.
Solution: A path with a length of 291.

The problem environment \code{lau15} is a list with the following functions: 

\enumerate{
\item \code{lau15$name()}:  \code{"lau15"}, the name of the TSP  
                            problem environment.
\item \code{lau15$genelength()}: 15, the number of cities on the round trip.
\item \code{lau15$dist()}: The distance matrix of the problem.
\item \code{lau15$cities()}: A list of city names or the vector 
                        \code{1:lau15$genelength()}.
\item \code{lau15$f (permutation, gene = 0, lF = 0, tour = TRUE)}: 
                    The fitness function. Computes the roundtrip 
                    for permutation of cities.
\item \code{lau15$solution()}: 291, the known optimal solution of lau15.
\item \code{lau15$path()}: The permutation for the optimal roundtrip.
\item \code{lau15$show(p)}: Prints the roundtrip \code{p}.
\item \code{lau15$greedy(startposition, k)}: Computes a path of length
                         \code{k} starting at \code{startposition} 
                         by choosing the nearest city.
\item \code{lau15$kBestGreedy(k, tour=TRUE)}:
                         Computes the best greedy path/tour with 
                         k cities. 
\item \code{lau15$rnd2Opt(permutation, maxtries=5)}:
                         Tries to find a better permutation by 
                         at most 5 random 2-opt heuristics.
\item \code{lau15$LinKernighan(permutation, maxtries=5)}:
               A randomized Lin-Kernigan heuristic implemented 
               as a sequence of randomized 2-opt moves.
}
}
\references{
Lau, H. T. (1986):
\emph{Combinatorial Heuristic Algorithms in FORTRAN}.
Springer, 1986. p. 61. <doi:10.1007/978-3-642-61649-5>
}
\seealso{
Other Problem Environments: 
\code{\link{DeJongF4Factory}()},
\code{\link{DelayedPFactory}()},
\code{\link{Parabola2DEarlyFactory}()},
\code{\link{Parabola2DErrFactory}()},
\code{\link{Parabola2DFactory}()},
\code{\link{envXOR}},
\code{\link{newEnvXOR}()},
\code{\link{newTSP}()}
}
\concept{Problem Environments}
\keyword{datasets}
