% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parModel.R
\name{futureLapplyHet}
\alias{futureLapplyHet}
\title{Future apply of R-package \code{future.apply} configured
for a tasks with heterogenous execution times.}
\usage{
futureLapplyHet(pop, EvalGene, lF)
}
\arguments{
\item{pop}{Population of genes.}

\item{EvalGene}{Function for evaluating a gene.}

\item{lF}{Local function factory which provides 
all functions needed in \code{EvalGene}.}
}
\value{
Fitness vector.
}
\description{
The \code{lapply()} function is redefined as as 
\code{future.apply::future_lapply()}.

Henrik Bengtsson recommends that the configuration of the 
parallel/distributed programming environment should be kept 
outside the package and left to the user. 
The advantage is that the user may take advantage of all 
parallel/distributed available backends for the Future API.
}
\details{
This configuration has an increased communication and 
  synchronization overhead.
}
\examples{
pop<-xegaInitPopulation(30, lFxegaGaGene)
library(future)
plan(multisession, workers=2)
popnew<-futureLapplyHet(pop, lFxegaGaGene$EvalGene, lFxegaGaGene)
plan(sequential)

}
\references{
Bengtsson H (2021). “A Unifying Framework for Parallel and 
Distributed Processing in R using Futures.” 
The R Journal, 13(2), 208–227. <doi:10.32614/RJ-2021-048>
}
\seealso{
Other Execution Model: 
\code{\link{MClapply}()},
\code{\link{MClapplyHet}()},
\code{\link{PparLapply}()},
\code{\link{PparLapplyHet}()},
\code{\link{futureLapply}()}
}
\concept{Execution Model}
