% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xegaDfScaleFactor.R
\name{DETVSF}
\alias{DETVSF}
\title{Scale factor with time dependent linear decay.}
\usage{
DETVSF(lF)
}
\arguments{
\item{lF}{Local configuration.}
}
\value{
A scale factor.
}
\description{
The scale factor is linear decaying from an upper bound 
             to a lower bound with the number of generations.
             The scale factor is computed by 
             \code{UB-(UB-LB)*(t/T)}.
             See section 16.2 of Sharma et al. (2019), p.941 and
             Das et al. (2005).
}
\details{
The parameters are constant functions defined in \code{lF}:
         \enumerate{
         \item UB is the upper bound of the scale factor
               (\code{lF$ScaleFactor1}).
         \item LB is lower upper bound of the scale factor
               (\code{lF$ScaleFactor2}).
         \item t is the current iteration 
               (\code{lF$cGeneration}).
         \item T is the total number of generations 
               (\code{lF$Generations}).
          }

          A simple check shows that 
          the formulas given in both papers are not correct.
}
\examples{
parm<-function(x){function() {return(x)}}
lF<-list()
lF$ScaleFactor1<-parm(1.10)
lF$ScaleFactor2<-parm(0.5)
lF$Generations<-parm(4)
lF$cGeneration<-parm(0)
DETVSF(lF)
lF$cGeneration<-parm(1)
DETVSF(lF)
lF$cGeneration<-parm(2)
DETVSF(lF)
lF$cGeneration<-parm(3)
DETVSF(lF)
lF$cGeneration<-parm(4)
DETVSF(lF)
}
\references{
Sharma, Prashant; Sharma, Harish; Kumar, Sandeep; Bansal, Jagdish Chand
(2019):
A Review on Scale Factor Strategies in Differential Evolution Algorithm.
pp. 925-934. In:
Bansal, Jagdish Chand et al. (2019)
Soft Computing for Problem Solving.
Advances in Intelligent Systems and Computing, Vol. 817.
Springer, Singapore, 2019. (ISBN:978-981-13-1594-7)

Das, Swagatam; Konar, Amit; Chakraborty, Uday K. (2005):
Two Improved Differential Evolution Schemes for Faster Global Search.
pp. 991-998. In:  
Proceedings of the 7th Annual Conference on 
Genetic and Evolutionary Computation, Association for Computing Machinery,
New York. (doi:10.1145/1068009.1068177)
}
\seealso{
Other Scale Factor: 
\code{\link{CauchySF}()},
\code{\link{ConstScaleFactor}()},
\code{\link{FitnessBasedSelfAdaptiveSF}()},
\code{\link{RandomGaussianSF}()},
\code{\link{UniformRandomScaleFactor}()},
\code{\link{UniformRandomScaleFactorDERSF}()}
}
\concept{Scale Factor}
