% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BNF.R
\name{makeStartSymbol}
\alias{makeStartSymbol}
\title{Extracts the numerical identifier of the start symbol of the grammar.}
\usage{
makeStartSymbol(BNF, ST)
}
\arguments{
\item{BNF}{A character string with the BNF.}

\item{ST}{A symbol table.}
}
\value{
The numerical identifier of the start symbol of the BNF.
}
\description{
\code{makeStartSymbol()} returns 
             the start symbol's numerical identifier 
              from a specification of a context-free grammar in BNF.   
              Warning: No error checking implemented.
}
\examples{
a<-booleanGrammar()$BNF
ST<-makeSymbolTable(a)
makeStartSymbol(a,ST)

}
\seealso{
Other Compiler Steps: 
\code{\link{compileShortPT}()},
\code{\link{makeProductionTable}()},
\code{\link{makeSymbolTable}()}
}
\concept{Compiler Steps}
