% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/x3p_select.R
\name{x3p_circle_select}
\alias{x3p_circle_select}
\title{Select a circle area on the surface of an x3p file using rgl}
\usage{
x3p_circle_select(x3p, col = "#FF0000", update = TRUE)
}
\arguments{
\item{x3p}{x3p file}

\item{col}{character value of the selection color}

\item{update}{boolean value, whether the rgl window should be updated to show the selected circle}
}
\value{
x3p file with selected circle in mask
}
\description{
In the active rgl window select a circle on the scan's surface by clicking on three points along the circumference.
Make sure that x3p file and the rgl window match. If no rgl window is active, an rgl window opens with the scan.
}
\examples{
\dontrun{
if (interactive) {
  if (!file.exists("fadul1-1.x3p")) {
    url <- "https://tsapps.nist.gov/NRBTD/Studies/CartridgeMeasurement/DownloadMeasurement"
    file <- "2d9cc51f-6f66-40a0-973a-a9292dbee36d"
    download.file(file.path(url, file), destfile="fadul1-1.x3p")
  }
  x3p <- x3p_read("fadul1-1.x3p")
  x3p_image(x3p, size=c(500,500), zoom=.8)
  x3p <- x3p_circle_select(x3p, update=TRUE, col="#FF0000") 

  logo <- x3p_read(system.file("csafe-logo.x3p", package="x3ptools"))
  x3p_image(logo, size=c(500,500), zoom = 1)
  x3p_circle_select(logo, update=TRUE, col="#00FF00") 
}}
}
