% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-table.R
\name{get_table}
\alias{get_table}
\title{Download data from any WRDS table}
\usage{
get_table(wrds, library, table, columns = NULL, n = Inf, lazy = TRUE)
}
\arguments{
\item{wrds}{A \code{DBIConnection} object returned by \code{\link[=wrds_connect]{wrds_connect()}}.}

\item{library}{Character. The name of the library (schema), e.g., \code{"crsp"},
\code{"comp"}, \code{"ibes"}.}

\item{table}{Character. The name of the table within the library.}

\item{columns}{Character vector of columns to return. If \code{NULL} (default),
returns all columns. Use \code{\link[=describe_table]{describe_table()}} to see available columns.}

\item{n}{Maximum number of rows to return. Defaults to \code{Inf} (all rows).
Use a smaller value (e.g., \code{n = 100}) to preview data.}

\item{lazy}{If \code{TRUE} (default), returns a lazy \code{tbl} for further
filtering with dplyr. Set to \code{FALSE} to collect immediately.}
}
\value{
A \code{tbl_lazy} object (if \code{lazy = TRUE}) or a tibble (if \code{lazy = FALSE}).
}
\description{
Generic function to download data from any table in the WRDS database.
Returns a lazy table by default, allowing you to build queries with
dplyr before collecting.
}
\details{
This function provides generic access to any WRDS table. For commonly-used
tables with standard research filters, prefer the specialized functions:
\itemize{
\item \code{\link[=get_compustat]{get_compustat()}} for Compustat fundamentals with standard filters
\item \code{\link[=get_company]{get_company()}} for company header data
\item \code{\link[=link_ccm]{link_ccm()}} for CRSP-Compustat linking
}

The lazy table can be filtered, selected, and mutated using dplyr verbs,
which are translated to SQL and executed on the server:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{get_table(wrds, "crsp", "msf") |>
  filter(date >= "2025-01-01") |>
  select(permno, date, ret, prc) |>
  collect()
}\if{html}{\out{</div>}}
}
\examples{
\dontrun{
wrds <- wrds_connect()

# Preview table structure first
describe_table(wrds, "crsp", "msf")

# Get a lazy table and build your query
get_table(wrds, "crsp", "msf") |>
  dplyr::filter(date >= "2025-01-01") |>
  dplyr::select(permno, date, ret, prc, vol) |>
  dplyr::collect()

# Collect immediately with specific columns
get_table(wrds, "crsp", "dsf",
  columns = c("permno", "date", "ret", "prc"),
  lazy = FALSE,
  n = 1000
)

# Access any table in any library
get_table(wrds, "ibes", "statsum_epsus") |>
  dplyr::filter(fpedats >= "2025-01-01") |>
  dplyr::collect()

wrds_disconnect(wrds)
}
}
\seealso{
\code{\link[=describe_table]{describe_table()}} to explore table structure,
\code{\link[=list_tables]{list_tables()}} to list available tables in a library
}
