% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wordsearch.R
\name{wordsearch}
\alias{wordsearch}
\title{Create a wordsearch puzzle}
\usage{
wordsearch(
  words = c("finding", "needles", "inside", "haystacks"),
  clues = words,
  r = 10,
  c = 10,
  image = NULL
)
}
\arguments{
\item{words}{a vector of hidden words (character/vector)}

\item{clues}{a vector of word clues (optional; character/vector)}

\item{r}{number of rows}

\item{c}{number of columns}

\item{image}{path to an image that the resulting grid should look like.NULL for no shape}
}
\value{
wordsearch object
}
\description{
Create a wordsearch puzzle
}
\examples{
# Example 1 ----
words <- c("dog", "cat", "horse", "frog", "cow", "fox")
ex1 <- wordsearch(words, r = 10, c = 10)
plot(ex1, solution = TRUE)

# Example 2 ----
clues <- c("Bark", "Meow", "Neigh", "Ribbit", "Moo", "Nee Nee Nee")
ex2 <- wordsearch(words = words, clues = clues)
plot(ex2, solution = TRUE, title = "Animal Sounds", legend_size = 4)

# Example 3 ----
math <- dplyr::tribble(
  ~problem,  ~solution,
  "2 + 2",   "four",
  "5 + 3",   "eight",
  "9 - 4",   "five",
  "1 + 0",   "one",
  "2 + 1",   "three",
  "5 + 5",   "ten",
  "6 - 6",   "zero"
 )
 ex3 <- wordsearch(words = math$solution, clues = math$problem)
 plot(ex3, solution = TRUE, title = "Math is Fun")

}
