% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-generator.R
\name{ModelGenerator}
\alias{ModelGenerator}
\title{Generates n-gram models from a text file}
\description{
It provides a method for generating n-gram models. The n-gram models may be
customized by specifying data cleaning and tokenization options.
}
\details{
It provides a method that generates a n-gram model. The n-gram model
may be customized by specifying the data cleaning and tokenization options.

The data cleaning options include removal of punctuation, stop words, extra
space, non-dictionary words and bad words. The tokenization options include
n-gram number and word stemming.
}
\examples{

## ------------------------------------------------
## Method `ModelGenerator$generate_model`
## ------------------------------------------------

# Start of environment setup code
# The level of detail in the information messages
ve <- 0
# The name of the folder that will contain all the files. It will be
# created in the current directory. NULL implies tempdir will be used
fn <- NULL
# The required files. They are default files that are part of the
# package
rf <- c("input.txt")
# An object of class EnvManager is created
em <- EnvManager$new(ve = ve, rp = "./")
# The required files are downloaded
ed <- em$setup_env(rf, fn)
# End of environment setup code

# ModelGenerator class object is created
mg <- ModelGenerator$new(
    name = "default-model",
    desc = "1 MB size and default options",
    fn = "def-model.RDS",
    df = "input.txt",
    n = 4,
    ssize = 0.99,
    dir = ed,
    dc_opts = list(),
    tg_opts = list(),
    ve = ve
)
# The n-gram model is generated
mg$generate_model()

# The test environment is removed. Comment the below line, so the
# files generated by the function can be viewed
em$td_env()
}
\section{Super class}{
\code{\link[wordpredictor:Base]{wordpredictor::Base}} -> \code{ModelGenerator}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ModelGenerator-new}{\code{ModelGenerator$new()}}
\item \href{#method-ModelGenerator-generate_model}{\code{ModelGenerator$generate_model()}}
\item \href{#method-ModelGenerator-clone}{\code{ModelGenerator$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ModelGenerator-new"></a>}}
\if{latex}{\out{\hypertarget{method-ModelGenerator-new}{}}}
\subsection{Method \code{new()}}{
It initializes the current object. It is used to set the maximum
n-gram number, sample size, input file name, data cleaner options,
tokenization options and verbose option.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ModelGenerator$new(
  name = NULL,
  desc = NULL,
  fn = NULL,
  df = NULL,
  n = 4,
  ssize = 0.3,
  dir = ".",
  dc_opts = list(),
  tg_opts = list(),
  ve = 0
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{The model name.}

\item{\code{desc}}{The model description.}

\item{\code{fn}}{The model file name.}

\item{\code{df}}{The path of the input text file. It should be the short
file name and should be present in the data directory.}

\item{\code{n}}{The n-gram size of the model.}

\item{\code{ssize}}{The sample size as a proportion of the input file.}

\item{\code{dir}}{The directory containing the input and output files.}

\item{\code{dc_opts}}{The data cleaner options.}

\item{\code{tg_opts}}{The token generator options.}

\item{\code{ve}}{The level of detail in the information messages.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ModelGenerator-generate_model"></a>}}
\if{latex}{\out{\hypertarget{method-ModelGenerator-generate_model}{}}}
\subsection{Method \code{generate_model()}}{
It generates the model using the parameters passed to
the object's constructor. It generates a n-gram model file and saves
it to the model directory.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ModelGenerator$generate_model()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Start of environment setup code
# The level of detail in the information messages
ve <- 0
# The name of the folder that will contain all the files. It will be
# created in the current directory. NULL implies tempdir will be used
fn <- NULL
# The required files. They are default files that are part of the
# package
rf <- c("input.txt")
# An object of class EnvManager is created
em <- EnvManager$new(ve = ve, rp = "./")
# The required files are downloaded
ed <- em$setup_env(rf, fn)
# End of environment setup code

# ModelGenerator class object is created
mg <- ModelGenerator$new(
    name = "default-model",
    desc = "1 MB size and default options",
    fn = "def-model.RDS",
    df = "input.txt",
    n = 4,
    ssize = 0.99,
    dir = ed,
    dc_opts = list(),
    tg_opts = list(),
    ve = ve
)
# The n-gram model is generated
mg$generate_model()

# The test environment is removed. Comment the below line, so the
# files generated by the function can be viewed
em$td_env()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ModelGenerator-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ModelGenerator-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ModelGenerator$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
