% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iwish_psr.R
\name{iwish_psr}
\alias{iwish_psr}
\title{Coefficient Matrix \eqn{\tilde{\mathcal{H}}_k}}
\usage{
iwish_psr(k, alpha = 2)
}
\arguments{
\item{k}{The order of the \eqn{\tilde{\mathcal{H}}_k} matrix (a positive integer)}

\item{alpha}{The type of Wishart distribution (\eqn{\alpha = 2/\beta}):
\itemize{
\item 1/2: Quaternion Wishart
\item 1: Complex Wishart
\item 2: Real Wishart (default)
}}
}
\value{
A list with two elements:
\itemize{
\item \code{c}: A 3-dimensional array containing the coefficient matrices of the numerator of \eqn{\tilde{\mathcal{H}}_k} in descending powers of \eqn{n1}, where \eqn{n1 = n - m + 1 - \alpha}
\item \code{den}: A vector containing the coefficients of the denominator of \eqn{\tilde{\mathcal{H}}_k}, in descending powers of \eqn{n1}
}
}
\description{
This function computes the coefficient matrix \eqn{\tilde{\mathcal{H}}_k} for \eqn{W \sim W_m^{\beta}(n, \Sigma)}.
}
\examples{
# Example 1:
iwish_psr(2) # For real Wishart distribution with k = 2

# Example 2:
iwish_psr(4, 1) # For complex Wishart distribution with k = 4

# Example 3:
iwish_psr(2, 1/2) # For quaterion Wishart distribution with k = 2

}
