% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/global.rmse.R
\name{global.rmse}
\alias{global.rmse}
\title{Plots in a single window the RMSE of each model.}
\usage{
global.rmse(
  wpls = NULL,
  col.cal = "blue",
  col.cv = "red",
  col.strip.background = "steelblue",
  xlab = NULL,
  ylab = NULL,
  title = NULL
)
}
\arguments{
\item{wpls, }{object obtained from \strong{cv.wpls}.}

\item{col.cal, }{color for the calibration line.}

\item{col.cv, }{color for the cross-validation line.}

\item{col.strip.background, }{color of the banner for each window.}

\item{xlab, }{title of the x axis.}

\item{ylab, }{title of the y axis.}

\item{title, }{title of the plot.}
}
\value{
Plot of RMSE of each spectra region used to compute PLS.
}
\description{
Plots in a single window the RMSE of each model.
}
\examples{
data(beer)
conc=beer[,1]
sp=beer[,2:ncol(beer)]
names(sp)=convert.names.wl(1100,2250,2)
conc=unlist(conc)
mywpls=cv.wpls(sp, conc,mode='wpls', windows = 5)
global.rmse(mywpls,col.cal='navy',
               col.cv='red',
               col.strip.background='orange',
               xlab='Component',
               ylab='RMSE')
}
