% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rasch_DIF.R
\name{rasch_DIF}
\alias{rasch_DIF}
\title{Perform analysis of Differential Item Functioning (DIF) for Rasch Model}
\usage{
rasch_DIF(
  df,
  vars_metric,
  vars_DIF,
  residuals_PCM,
  split_strategy = NULL,
  print_results = FALSE,
  path_output = NULL,
  breaks = 6
)
}
\arguments{
\item{df}{a data frame of individual survey data, where each row is an individual}

\item{vars_metric}{a character vector of items to use in the Rasch Analysis}

\item{vars_DIF}{a string with the column names to use for analyzing differential item functioning (DIF). Default is NULL, to skip analysis of DIF.}

\item{residuals_PCM}{a matrix giving the residuals of the person parameters from the Rasch Model. Row names are the numbers of the people and the columns are for each variable.}

\item{split_strategy}{a named list giving the strategy to take for splitting variables by categories, passed to \code{rasch_split()}. One element of the list per variable to split by. Each element of the list must be a character vector of column names to split. The names of the list are the variables to split each group of variables by. Default is NULL, to not split items.}

\item{print_results}{a logical value indicating whether or not to print various files displaying results from the Rasch Model. Default is FALSE, to not print the files.}

\item{path_output}{a string with the path to the output folder. Default is NULL.}

\item{breaks}{a numeric value giving the number if class intervals. Default is 6.}
}
\value{
a list with results from the DIF analysis: 
\item{df_DIF_class}{the person residuals from the Rasch Model, the assigned class intervals, and the variables used for DIF analysis}
\item{tab_aov_DIF}{the results of the ANOVA used to analyze DIF}
\item{DIF_results}{string of various that exhibit some form of DIF}
}
\description{
Perform analysis of Differential Item Functioning (DIF) for Rasch Model
}
\details{
Differential Item Functioning (DIF) refers to the circumstance when different groups in a sample respond to items in different ways. For instance, DIF would be observed if men and women had different patterns of responses to a set of survey questions. DIF can cause poor fit for the Rasch Model, and therefore should be analyzed. This function uses ANOVA to find DIF by the variables supplied and by a generated class interval.
}
\note{
Currently the calculation of the class intervals is quite slow. Reducing the number of breaks can improve speed.
}
\seealso{
Other rasch functions: 
\code{\link{rasch_df_nest}()},
\code{\link{rasch_drop}()},
\code{\link{rasch_factor}()},
\code{\link{rasch_mds_children}()},
\code{\link{rasch_mds}()},
\code{\link{rasch_model_children}()},
\code{\link{rasch_model}()},
\code{\link{rasch_quality_children_print}()},
\code{\link{rasch_quality_children}()},
\code{\link{rasch_rawscore}()},
\code{\link{rasch_recode}()},
\code{\link{rasch_rescale_children}()},
\code{\link{rasch_rescale}()},
\code{\link{rasch_split_age}()},
\code{\link{rasch_split}()},
\code{\link{rasch_testlet}()}
}
\concept{rasch functions}
