% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/averages.R
\name{perform_average}
\alias{perform_average}
\title{Perform average on second-by-second data}
\usage{
perform_average(
  .data,
  type = c("bin", "rolling", "ensemble"),
  bins = 30,
  bin_method = c("ceiling", "round", "floor"),
  rolling_window = 30
)
}
\arguments{
\item{.data}{The second-by-second data retrieved from \code{interpolate()}.}

\item{type}{The type of the average to perform. Either \code{bin}, \code{rolling}, or \code{ensemble}.}

\item{bins}{If bin-average is chosen, here you can specify the size of the bin-average, in seconds. Default to 30-s bin-average.}

\item{bin_method}{Method for determining bin boundaries when \code{type = "bin"}.
One of \code{"ceiling"} (default), \code{"round"}, or \code{"floor"}.
\code{"ceiling"} is recommended as it ensures no data points are excluded
from the analysis by always rounding up to the next bin boundary.}

\item{rolling_window}{If rolling-average is chosen, here you can specify the rolling-average window, in seconds. Default to 30-s rolling-average.}
}
\value{
a \link[tibble:tibble-package]{tibble}
}
\description{
This function performs either a bin- or a rolling-average on the interpolated data.
You must specify the \code{type} of the average before continuing.
}
\details{
Ensemble average is used in VO2 kinetics analysis, where a series of transitions from baseline to
the moderate/heavy/severe intensity-domain is ensembled averaged into a single 'bout' for further data processing.

When using bin averaging, the \code{bin_method} parameter controls how time points are assigned to bins:
\itemize{
\item \code{"ceiling"}: Rounds up to the next bin boundary (recommended)
\item \code{"round"}: Rounds to the nearest bin boundary
\item \code{"floor"}: Rounds down to the previous bin boundary
}
}
\examples{
\dontrun{
## get file path from example data
path_example <- system.file("example_cosmed.xlsx", package = "whippr")

## read data
df <- read_data(path = path_example, metabolic_cart = "cosmed")

## interpolate and perform 30-s bin-average
df \%>\%
 interpolate() \%>\%
 perform_average(type = "bin", bins = 30)

## interpolate and perform 30-s rolling-average
df \%>\%
 interpolate() \%>\%
 perform_average(type = "rolling", rolling_window = 30)
}
}
