% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/when.R
\name{when}
\alias{when}
\title{\code{when} S3 class}
\usage{
when(
  name = NULL,
  type = NULL,
  locale = NULL,
  start = lubridate::today(),
  end = lubridate::today(),
  values = NULL,
  ...
)
}
\arguments{
\item{name}{A string, table name.}

\item{type}{A string, type of calendar (NULL, 'iso', 'epi' or 'time').}

\item{locale}{A locale, to use for day and month names.}

\item{start}{A string, start of the period to be included in the dimension.}

\item{end}{A string, end of the period to be included in the dimension.}

\item{values}{A vector of string.}

\item{...}{Rest of boolean configuration parameters.}
}
\value{
A \code{when} object.
}
\description{
Creates a \code{when} object.
}
\details{
Using the parameters of this function we can configure practically  all the
elements of the dimension. Alternatively, we can use the configuration functions
to define the available options.

We discuss the parameters in each of the specific configuration functions.
}
\examples{

td_1 <- when()

td_2 <- when(type = 'time')

}
\seealso{
\code{\link{generate_table}}, \code{\link{get_table}}

Other dimension definition: 
\code{\link{define_characteristics}()},
\code{\link{define_instances}()},
\code{\link{get_attribute_definition_function}()},
\code{\link{get_day_part}()},
\code{\link{get_week_date_range}()},
\code{\link{select_date_levels}()},
\code{\link{select_day_level}()},
\code{\link{select_month_level}()},
\code{\link{select_quarter_level}()},
\code{\link{select_semester_level}()},
\code{\link{select_time_level}()},
\code{\link{select_week_level}()},
\code{\link{select_year_level}()},
\code{\link{set_attribute_definition_function}()},
\code{\link{set_day_part}()}
}
\concept{dimension definition}
