% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/words_from_coords.R
\name{words_from_coords}
\alias{words_from_coords}
\title{Get what3words address from coordinates}
\usage{
words_from_coords(lat, lon, language = "en", full_details = FALSE)
}
\arguments{
\item{lat}{Latitude}

\item{lon}{Longitude}

\item{language}{Code for the language of the returned words.}

\item{full_details}{Whether to return the full details from the API, or only
the what3words address for the coordinates.}
}
\value{
If \code{full_details} is FALSE (the default), returns a character vector
of the what3words for the submitted coordinates. Otherwise returns a list of
the full details returned by the API.
}
\description{
Get what3words address from coordinates
}
\examples{
\dontshow{if (!identical(Sys.getenv("WTW_API_KEY"), "")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
words_from_coords(lat = 51.5095, lon = -0.1266)
\dontshow{\}) # examplesIf}
}
