% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{plot_mod.default}
\alias{plot_mod.default}
\title{Add Estimated Population Line to a Probability Plot}
\usage{
\method{plot_mod}{default}(
  p_obj,
  x,
  dist_params,
  distribution = c("weibull", "lognormal", "loglogistic", "sev", "normal", "logistic",
    "weibull3", "lognormal3", "loglogistic3", "exponential", "exponential2"),
  title_trace = "Fit",
  ...
)
}
\arguments{
\item{p_obj}{A plot object returned by \link{plot_prob}.}

\item{x}{A numeric vector containing the x-coordinates of the respective
regression line.}

\item{dist_params}{A (named) numeric vector of estimated location and scale
parameters for a specified distribution. The order of elements is important.
First entry needs to be the location parameter \eqn{\mu} and the second
element needs to be the scale parameter \eqn{\sigma}. If a three-parametric
model is used the third element is the threshold parameter \eqn{\gamma}.}

\item{distribution}{Supposed distribution of the random variable.}

\item{title_trace}{A character string which is assigned to the legend trace.}

\item{...}{Further arguments passed to or from other methods. Currently not used.}
}
\value{
A plot object containing the probability plot with plotting positions
and the estimated regression line.
}
\description{
This function adds an estimated regression line to an existing probability
plot (\link{plot_prob}).
}
\examples{
# Vectors:
cycles <- alloy$cycles
status <- alloy$status

# Probability estimation
prob_tbl <- estimate_cdf(x = cycles, status = status, method = "johnson")

# Example 1: Probability Plot and Regression Line Three-Parameter-Weibull:
plot_weibull <- plot_prob(
  x = prob_tbl$x,
  y = prob_tbl$prob,
  status = prob_tbl$status,
  id = prob_tbl$id,
  distribution = "weibull"
)

rr <- rank_regression(
  x = prob_tbl$x,
  y = prob_tbl$prob,
  status = prob_tbl$status,
  distribution = "weibull3"
)

plot_reg_weibull <- plot_mod(
  p_obj = plot_weibull,
  x = prob_tbl$x,
  dist_params = rr$coefficients,
  distribution = "weibull3"
)



# Example 2: Probability Plot and Regression Line Three-Parameter-Lognormal:
plot_lognormal <- plot_prob(
  x = prob_tbl$x,
  y = prob_tbl$prob,
  status = prob_tbl$status,
  id = prob_tbl$id,
  distribution = "lognormal"
)

rr_ln <- rank_regression(
  x = prob_tbl$x,
  y = prob_tbl$prob,
  status = prob_tbl$status,
  distribution = "lognormal3"
)

plot_reg_lognormal <- plot_mod(
  p_obj = plot_lognormal,
  x = prob_tbl$x,
  dist_params = rr_ln$coefficients,
  distribution = "lognormal3"
)

## Mixture Identification
# Vectors:
hours <- voltage$hours
status <- voltage$status

# Probability estimation:
prob_mix <- estimate_cdf(
  x = hours,
  status = status,
  method = "johnson"
)

}
\references{
Meeker, William Q; Escobar, Luis A., Statistical methods for
reliability data, New York: Wiley series in probability and statistics, 1998
}
\seealso{
\link{plot_mod}
}
