% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ml_estimation.R
\encoding{UTF-8}
\name{ml_estimation}
\alias{ml_estimation}
\alias{ml_estimation.wt_reliability_data}
\title{ML Estimation for Parametric Lifetime Distributions}
\usage{
ml_estimation(x, ...)

\method{ml_estimation}{wt_reliability_data}(
  x,
  distribution = c("weibull", "lognormal", "loglogistic", "sev", "normal", "logistic",
    "weibull3", "lognormal3", "loglogistic3", "exponential", "exponential2"),
  wts = rep(1, nrow(x)),
  conf_level = 0.95,
  start_dist_params = NULL,
  control = list(),
  ...
)
}
\arguments{
\item{x}{A \code{tibble} with class \code{wt_reliability_data} returned by \link{reliability_data}.}

\item{...}{Further arguments passed to or from other methods. Currently not used.}

\item{distribution}{Supposed distribution of the random variable.}

\item{wts}{Optional vector of case weights. The length of \code{wts} must be equal
to the number of observations in \code{x}.}

\item{conf_level}{Confidence level of the interval.}

\item{start_dist_params}{Optional vector with initial values of the
(log-)location-scale parameters.}

\item{control}{A list of control parameters (see 'Details' and
\link[stats:optim]{optim}).}
}
\value{
A list with classes \code{wt_model}, \code{wt_ml_estimation} and \code{wt_model_estimation}
which contains:
\itemize{
\item \code{coefficients} : A named vector of estimated coefficients (parameters of the
assumed distribution). \strong{Note}: The parameters are given in the
(log-)location-scale-parameterization.
\item \code{confint} : Confidence intervals for the (log-)location-scale parameters.
\item \code{shape_scale_coefficients} : Only included if \code{distribution} is \code{"weibull"}
or \code{"weibull3"} (parameterization used in \link[stats:Weibull]{Weibull}).
\item \code{shape_scale_confint} : Only included if \code{distribution} is \code{"weibull"}
or \code{"weibull3"}. Confidence intervals for scale \eqn{\eta} and shape \eqn{\beta}
(and threshold \eqn{\gamma} if \code{distribution = "weibull3"}).
\item \code{varcov} : Estimated variance-covariance matrix of (log-)location-scale parameters.
\item \code{logL} : The log-likelihood value.
\item \code{aic} : Akaike Information Criterion.
\item \code{bic} : Bayesian Information Criterion.
\item \code{data} : A \code{tibble} with class \code{wt_reliability_data} returned by
\item \code{distribution} : Specified distribution.
}
}
\description{
This function estimates the parameters of a parametric lifetime distribution
for complete and (multiple) right-censored data. The parameters
are determined in the frequently used (log-)location-scale parameterization.

For the Weibull, estimates are additionally transformed such that they are in
line with the parameterization provided by the \emph{stats} package
(see \link[stats:Weibull]{Weibull}).
}
\details{
Within \code{ml_estimation}, \link[stats:optim]{optim} is called with \code{method = "BFGS"}
and \code{control$fnscale = -1} to estimate the parameters that maximize the
log-likelihood (see \link{loglik_function}). For threshold models, the profile
log-likelihood is maximized in advance (see \link{loglik_profiling}). Once the
threshold parameter is determined, the threshold model is treated like a
distribution without threshold (lifetime is reduced by threshold estimate)
and the general optimization routine is applied.

Normal approximation confidence intervals for the parameters are computed as well.
}
\examples{
# Reliability data preparation:
## Data for two-parametric model:
data_2p <- reliability_data(
  shock,
  x = distance,
  status = status
)

## Data for three-parametric model:
data_3p <- reliability_data(
  alloy,
  x = cycles,
  status = status
)

# Example 1 - Fitting a two-parametric weibull distribution:
ml_2p <- ml_estimation(
  data_2p,
  distribution = "weibull"
)

# Example 2 - Fitting a three-parametric lognormal distribution:
ml_3p <- ml_estimation(
  data_3p,
  distribution = "lognormal3",
  conf_level = 0.99
)

}
\references{
Meeker, William Q; Escobar, Luis A., Statistical methods for
reliability data, New York: Wiley series in probability and statistics, 1998
}
