% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rainmeasure_conversion.R
\name{metric_to_inches}
\alias{metric_to_inches}
\title{Convert between standard metric units of measure for precipitation to inches}
\usage{
metric_to_inches(metric, unit.from, round = 2)
}
\arguments{
\item{metric}{Numeric vector of precipitation (in millimeters or centimeters)}

\item{unit.from}{A character string with the current units of the
observations (i.e., the units from which you want to convert)}

\item{round}{An integer indicating the number of decimal places to
round the converted value.}
}
\value{
A numeric vector of precipitation in inches.
}
\description{
\code{metric_to_inches} creates a numeric vector of precipitation measures in
  inches from a numeric vector of precipitation in common metric units
  (millimeters or centimeters).
}
\note{
Equations are from the source code for the National Weather Service
   Forecast Office \url{http://www.srh.noaa.gov/ama/?n=conversions}
}
\examples{
data(loveland)
loveland$Precip.in <- metric_to_inches(loveland$Precip.mm,
                                       unit.from = "mm",
                                       round = 2)
loveland

}
\author{
Joshua Ferreri \email{joshua.m.ferreri@gmail.com},
Brooke Anderson \email{brooke.anderson@colostate.edu}
}
\references{
\url{http://www.srh.noaa.gov/ama/?n=conversions}
}
\seealso{
\code{\link{inches_to_metric}}
}

