% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wdi_get_entities.R
\name{wdi_get_entities}
\alias{wdi_get_entities}
\title{Download all countries and regions from the World Bank API}
\usage{
wdi_get_entities(language = "en", per_page = 1000)
}
\arguments{
\item{language}{A character string specifying the language for the API
response. Defaults to \code{"en"} (English). Other supported options include
\code{"es"} (Spanish), \code{"fr"} (French), and others depending on the API.}

\item{per_page}{An integer specifying the number of records to fetch per
request. Defaults to \code{1000}.}
}
\value{
A tibble with the following columns:
\describe{
\item{entity_id}{A character string representing the entity's unique
identifier.}
\item{entity_name}{A character string for the name of the entity.}
\item{entity_iso2code}{A character string for the ISO2 country code.}
\item{entity_type}{A character string for the type of the entity
("country" or "region").}
\item{region_id}{A character string representing the region's unique
identifier.}
\item{region_name}{A character string for the name of the region.}
\item{region_iso2code}{A character string for the ISO2 region code.}
\item{admin_region_id}{A character string representing the administrative
region's unique identifier.}
\item{admin_region_name}{A character string for the name of the
administrative region.}
\item{admin_region_iso2code}{A character string for the ISO2 code of the
administrative region.}
\item{income_level_id}{A character string representing the entity's
income level.}
\item{income_level_name}{A character string for the name of the
income level.}
\item{income_level_iso2code}{A character string for the ISO2 code of the
income level.}
\item{lending_type_id}{A character string representing the lending type's
unique identifier.}
\item{lending_type_name}{A character string for the name of the lending
type.}
\item{lending_type_iso2code}{A character string for the ISO2 code of the
lending type.}
\item{capital_city}{A character string for the name of the capital city.}
\item{longitude}{A numeric value for the longitude of the entity.}
\item{latitude}{A numeric value for the latitude of the entity.}
}
}
\description{
This function retrieves information about entities (countries and regions)
from the World Bank API. It returns a tibble containing various details such
as the entity's ID, ISO2 code, name, region information, lending type,
capital city, and coordinates.
}
\details{
This function sends a request to the World Bank API to retrieve data
for all supported entities in the specified language. The data is then
processed into a tidy format and includes information about the country,
such as its ISO code, capital city, geographical coordinates, and additional
metadata about regions, income levels, and lending types.
}
\examples{
\dontshow{if (curl::has_internet()) withAutoprint(\{ # examplesIf}
# Download all entities in English
wdi_get_entities()

# Download all entities in Spanish
wdi_get_entities(language = "zh")
\dontshow{\}) # examplesIf}
}
