% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imputation.R
\name{impute_data}
\alias{impute_data}
\title{Impute Data}
\usage{
impute_data(
  input,
  vars,
  keep_vars = c(),
  return_mice = FALSE,
  impute_constant = NULL
)
}
\arguments{
\item{input}{data.frame with calibration variables}

\item{vars}{character vector with names of variables to be imputed}

\item{keep_vars}{character vector with names of additional variables that should be retained}

\item{return_mice}{boolean for whether to return mice object (for looking at logged events)}

\item{impute_constant}{numeric if not NULL will impute with provided constant}
}
\value{
data.frame with imputed versions of variables
}
\description{
Add imputed data columns to existing data.frame
}
\details{
For each of the specified variables, use all variables
to predict missing values. Populate actual (when available) and imputed
values into new columns appended with names appended with _I.

If you choose to return the mice object with return_mice, the function
output will be a list that includes the final data.frame and the mice output.
}
\examples{
calVars <- c(
  "SEX_A_R", "AGEP_A_R", "HISPALLP_A_R", "ORIENT_A_R", "HICOV_A_R", "EDUCP_A_R", "REGION_R",
  "EMPLASTWK_A_R", "HOUTENURE_A_R", "MARITAL_A_R"
)
stuVars <- "DIBTYPE_A_R"
nhis_keep_vars <- c("PPSU","PSTRAT","WTFA_A")

nhis_imputed <- impute_data(nhis_processed, c(calVars, stuVars), nhis_keep_vars)

}
