% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colors.R
\docType{data}
\name{wacolors}
\alias{wacolors}
\title{Washington State Color Palettes}
\format{
A list of character vectors containing the color palettes. Discrete
palette vectors contain names for each color.
}
\usage{
wacolors
}
\description{
A collection of colorblind-friendly color palettes for various settings in
the state of Washington. Colors were extracted from a set of photographs, and
then combined to form a set of continuous and discrete palettes.  Continuous
palettes were designed to be perceptually uniform, while discrete palettes
were chosen to maximize contrast at several different levels of overall
brightness and saturation. Each palette has been evaluated to ensure colors
are distinguishable by colorblind people.
}
\details{
Discrete palettes contain at most seven colors.  Don't create graphics that
use more than seven discrete colors.  You can color a map with four.
Anything more risks confusion.  Consider differentiating through faceting or
labels, instead.

\strong{Available continuous palettes}:

\figure{README-cont-palettes-1.png}

\figure{README-cont-palettes-2.png}

\figure{README-cont-palettes-3.png}

\figure{README-cont-palettes-4.png}

\figure{README-cont-palettes-5.png}

\figure{README-cont-palettes-6.png}

\figure{README-cont-palettes-7.png}

\figure{README-cont-palettes-8.png}

\figure{README-cont-palettes-9.png}

\figure{README-cont-palettes-10.png}

\figure{README-cont-palettes-11.png}

\figure{README-cont-palettes-12.png}

\figure{README-cont-palettes-13.png}

\figure{README-cont-palettes-14.png}

\figure{README-cont-palettes-15.png}

\figure{README-cont-palettes-16.png}

\figure{README-cont-palettes-17.png}

\strong{Available discrete palettes}:

\figure{README-disc-palettes-1.png}

\figure{README-disc-palettes-2.png}

\figure{README-disc-palettes-3.png}

\figure{README-disc-palettes-4.png}

\figure{README-disc-palettes-5.png}

\figure{README-disc-palettes-6.png}

\figure{README-disc-palettes-7.png}

\figure{README-disc-palettes-8.png}

\figure{README-disc-palettes-9.png}

\figure{README-disc-palettes-10.png}

\figure{README-disc-palettes-11.png}
}
\examples{
wacolors$rainier
wacolors$palouse[1:4]

}
\keyword{datasets}
