\name{grid.offsetXspline}
\alias{grid.offsetXspline}
\alias{offsetXsplineGrob}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
  Draw an X-spline offset curve.
}
\description{
  Draw an X-spline offset curve; the main curve is described
  by x/y control points and offset X-splines are calculated to the
  left and right of the main curve at the specified widths.
}
\usage{
offsetXsplineGrob(x, y, w, default.units="npc", shape=1,
                  open=TRUE, repEnds=TRUE, 
                  lineend="butt", mitrelimit=4,
                  render=if (open) vwPolygon else vwPath(),
                  gp=gpar(fill="black"), name=NULL, debug=FALSE)
grid.offsetXspline(...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x}{A numeric vector or unit describing x-locations.}
  \item{y}{A numeric vector or unit describing y-locations.}
  \item{w}{A numeric vector or unit describing widths at each location,
    or a width specification generated by \code{\link{widthSpline}}.}
  \item{default.units}{The units used if \code{x} or \code{y} are
    numeric vectors.}
  \item{shape}{A numeric value (or one per location) that controls
    the shape of the X-spline curve relative to the locations.}
  \item{open}{A boolean indicating whether to connect the last location
    back to the first location to produce a closed line.}
  \item{repEnds}{A logical indicating whether to replicate the
    first and last control points (so that the X-spline starts and
    ends at the first and last control points).  Can also be the
    special value \code{"extend"}, in which case the first and last
    control segments are extended (and the resulting X-spline is
    a little curvier at the ends).}
  \item{lineend}{The line ending style; one of \code{"round"},
    \code{"mitre"}, \code{"butt"}, or \code{"square"}.}
  \item{mitrelimit}{A numeric that controls when a mitre join is
    converted to a bevel join or a mitre ending
    is converted to a square ending.}
  \item{render}{A function that is used to render the outline of the path
    that is generated for the variable-width line.}
  \item{gp}{A set of graphical parameters; see \code{\link{gpar}}.}
  \item{name}{A name for the grob generated for the variable-width
    line.}
  \item{debug}{A logical indicating whether to produce graphical
    debugging output.}
  \item{\dots}{
    Arguments passed to \code{offsetXsplineGrob}.
  }
}
\details{
  See \code{\link{grid.xspline}} for more about the behaviour of X-splines.
}
\value{
  \code{grid.offsetXspline} is used for its side-effect of drawing a
  variable-width
  line;  \code{offsetXsplineGrob} returns a \code{"offsetXsplineGrob"} object.
}
\author{
  Paul Murrell
}
\seealso{
  \code{\link{grid.xspline}},
  \code{\link{grid.vwline}},
  \code{\link{grid.vwcurve}},
  \code{\link{grid.brushXspline}},
  \code{\link{grid.vwXspline}}
}
\examples{
grid.newpage()
x <- c(.2, .4, .6, .8)
y <- c(-.05, .05, -.05, .05)
w <- unit(c(2, 4, 6, 8), "mm")
grid.offsetXspline(x, y + .8, w)
grid.offsetXspline(x, y + .6, w,
                   shape=-1)
grid.offsetXspline(x, y + .4, w,
                   lineend="round")
grid.offsetXspline(x, y + .2, w,
                   gp=gpar(col="black"), debug=TRUE)
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ aplot }% use one of  RShowDoc("KEYWORDS")
