% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_dataset_summary_table.R
\name{calculate_category_percentages}
\alias{calculate_category_percentages}
\title{Calculate the percentage of categories in a data vector}
\usage{
calculate_category_percentages(data_vector)
}
\arguments{
\item{data_vector}{A vector of categorical data.}
}
\value{
A character string detailing the top   10 categories and their percentages, or a special message indicating not enough occurrences or unsupported data type.
}
\description{
This function calculates the percentage of each category in a given data vector and returns the top   10 categories along with their percentages.
If the data vector is of Date class, it is converted to POSIXct. If the sum of the percentages is not   100\%, an "Other" category is added to make up the difference, but only if the number of unique values exceeds  10.
If the data vector is of POSIXct class and the smallest percentage is less than   1\%, the function returns "Not enough occurrences."
}
\examples{
# Example with a character vector
data_vector <- c("cat", "dog", "bird", "cat", "dog", "cat", "other")
calculate_category_percentages(data_vector)

# Example with a Date vector
data_vector <- as.Date(c("2020-01-01", "2020-01-02", "2020-01-03"))
calculate_category_percentages(data_vector)
}
