% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_vpc_input_data.R
\name{standardize_column}
\alias{standardize_column}
\title{Confirm that a column is in the data, and rename data to prepare that column for later use.}
\usage{
standardize_column(dat, cols, colname, coldesc, what, default)
}
\arguments{
\item{dat}{An input data.frame or similar object}

\item{cols}{A list with an element for colname giving the name for colname in
\code{dat}.}

\item{colname}{The name of the column (character scalar)}

\item{coldesc}{The description of the column (character scalar)}

\item{what}{The description of the data (typically "observed" or "simulated")}

\item{default}{A default value (scalar or vector) to use if the column is not
found.}
}
\value{
If \code{colname} is already named \code{colname} in \code{dat},
  \code{dat} unchanged.  If not, check if \code{dat} has that column name
  already, and if so, name the existing \code{dat[[colname]]} to
  \code{dat[[paste0(colname, ".old")]]} and then rename
  \code{cols[[colname]]} to \code{colname}.
}
\description{
Confirm that a column is in the data, and rename data to prepare that column for later use.
}
