% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enbs.R
\name{pop_voi}
\alias{pop_voi}
\title{Population expected value of information}
\usage{
pop_voi(voi, pop, time, dis = 0.035)
}
\arguments{
\item{voi}{Vector of estimates of any per-person value of information
measure, e.g. the \code{evsi} column of the data frame returned by
\code{\link{evsi}} or the correspondingly-named columns of the
data frames returned by \code{\link{evppi}} or \code{\link{evpi}}.}

\item{pop}{Size of the population who would be affected by the decision.}

\item{time}{Time horizon over which discounting will be applied.}

\item{dis}{Discount rate used when converting per-person to population EVSI.}
}
\value{
A vector of population VoI estimates.
}
\description{
Convert per-person expected value of information to the population
expected value of information, given a discount rate over some
time horizon.
}
\details{
Calculated as \code{voi*pop/dis*(1 - exp(-dis*time))}, or \code{voi*pop}
if the discount rate is zero.  This is a continuous-time variant
of the typical discrete-time discounting formula.

Any arguments may be supplied as vectors, in which case, all
arguments are replicated to the length of the longest argument.
}
