% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiple_processing_threshold_v3.R
\name{threshold_apply}
\alias{threshold_apply}
\title{Threshold a video with pre-determined parameters}
\usage{
threshold_apply(
  threshold = 0.5,
  roi_name = "test",
  video_path = "image826.avi",
  radians = 0.217604550320612,
  xlength = 60,
  ylength = 242,
  xstart = 696,
  ystart = 323,
  image_list = NULL,
  fps = NULL
)
}
\arguments{
\item{threshold}{The threshold for the red channel. Range 0-1.}

\item{roi_name}{Name assigned to the region of interest}

\item{video_path}{Location of the video file to process}

\item{radians}{Degrees to rotate the image, in radians}

\item{xlength}{Number of x pixels in the ROI}

\item{ylength}{Number of y pixels in the ROI}

\item{xstart}{ROI starting x co-ordinate}

\item{ystart}{ROI starting y co-ordinate}

\item{image_list}{If pre-computed, a list of images to use rather than a video}

\item{fps}{Number of fps to process, this can be set lower for validation}
}
\value{
Saves the quantified CSV and overlaid video in the same directory as the video
}
\description{
Using pre-determined values this function generates ROI from a video. If parameters are not known, use select_roi()
This function is optimized to run in parallel, so should be relatively rapid. If running slowly, check the scratch disk is set correctly.
}
