% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FDM.R
\name{FDM}
\alias{FDM}
\alias{report.FDM}
\title{Functional data model}
\usage{
FDM(
  formula,
  order = 6,
  ts_model_fn = fable::ARIMA,
  coherent = FALSE,
  coherent_ts_model_fn = fable::ARFIMA,
  ...
)
}
\arguments{
\item{formula}{Model specification.}

\item{order}{Number of principal components to fit.}

\item{ts_model_fn}{Univariate time series modelling function for the coefficients. Any
model that works with the fable package is ok. Default is \code{\link[fable:ARIMA]{fable::ARIMA()}}.}

\item{coherent}{If TRUE, fitted models are stationary, other than for the case of
a key variable taking the value \code{geometric_mean} or \code{mean}. This is designed to work with
vitals produced using \code{\link{make_pr}()} and \code{\link{make_sd}}.
Default is FALSE.}

\item{coherent_ts_model_fn}{Time series modelling function to be used for coherent fitting.
\code{ts_model_fn} will be used for the \code{geometric_mean} or \code{mean} variables, with the
other variables being modelled using \code{coherent_ts_model_fn}. Default is \code{\link[fable:ARFIMA]{fable::ARFIMA()}}.}

\item{...}{Not used.}
}
\value{
A model specification.
}
\description{
Functional data model of mortality or fertility rates as a function of age.
\code{FDM()} returns a functional data model applied to the formula's response
variable as a function of age.
}
\examples{
hu <- norway_mortality |>
  dplyr::filter(Sex == "Female", Year > 2010) |>
  smooth_mortality(Mortality) |>
  model(hyndman_ullah = FDM(log(.smooth)))
report(hu)
autoplot(hu)
}
\references{
Hyndman, R. J., and Ullah, S. (2007) Robust forecasting of
mortality and fertility rates: a functional data approach.
\emph{Computational Statistics & Data Analysis}, 5, 4942-4956.
\url{https://robjhyndman.com/publications/funcfor/}

Hyndman, R. J., Booth, H., & Yasmeen, F. (2013). Coherent mortality
forecasting: the product-ratio method with functional time series models.
\emph{Demography}, 50(1), 261-283.
\url{https://robjhyndman.com/publications/coherentfdm/}
}
\author{
Rob J Hyndman
}
