% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visOmopTable.R
\name{visOmopTable}
\alias{visOmopTable}
\title{Generate a formatted table from a \verb{<summarised_result>}}
\usage{
visOmopTable(
  result,
  estimateName = character(),
  header = character(),
  settingsColumn = character(),
  groupColumn = character(),
  rename = character(),
  type = NULL,
  hide = character(),
  columnOrder = character(),
  factor = list(),
  style = NULL,
  showMinCellCount = TRUE,
  .options = list()
)
}
\arguments{
\item{result}{A \verb{<summarised_result>} object.}

\item{estimateName}{A named list of estimate names to join, sorted by
computation order. Use \verb{<...>} to indicate estimate names.}

\item{header}{A vector specifying the elements to include in the header.
The order of elements matters, with the first being the topmost header.
Elements in header can be:
\itemize{
\item Any of the columns returned by \code{tableColumns(result)} to create a header
for these columns.
\item Any other input to create an overall header.
}}

\item{settingsColumn}{A character vector with the names of settings to
include in the table. To see options use \code{settingsColumns(result)}.}

\item{groupColumn}{Columns to use as group labels, to see options use
\code{tableColumns(result)}. By default, the name of the new group will be the
tidy* column names separated by ";". To specify a custom group name, use a
named list such as:
list("newGroupName" = c("variable_name", "variable_level")).

*tidy: The tidy format applied to column names replaces "_" with a space and
converts to sentence case. Use \code{rename} to customise specific column names.}

\item{rename}{A named vector to customise column names, e.g.,
c("Database name" = "cdm_name"). The function renames all column names
not specified here into a tidy* format.}

\item{type}{Character string specifying the desired output table format.
See \code{tableType()} for supported table types. If \code{type = NULL}, global
options (set via \code{setGlobalTableOptions()}) will be used if available;
otherwise, a default \code{'gt'} table is created.}

\item{hide}{Columns to drop from the output table. By default, \code{result_id} and
\code{estimate_type} are always dropped.}

\item{columnOrder}{Character vector establishing the position of the columns
in the formatted table. Columns in either header, groupColumn, or hide will
be ignored.}

\item{factor}{A named list where names refer to columns (see available columns
in \code{tableColumns()}) and list elements are the level order of that column
to arrange the results. The column order in the list will be used for
arranging the result.}

\item{style}{Defines the visual formatting of the table.
This argument can be provided in one of the following ways:
\enumerate{
\item \strong{Pre-defined style:} Use the name of a built-in style (e.g., \code{"darwin"}).
See \code{tableStyle()} for available options.
\item \strong{YAML file path:} Provide the path to an existing \code{.yml} file defining
a new style.
\item \strong{List of custome R code:} Supply a block of custom R code or a named list
describing styles for each table section. This code must be specific to
the selected table type.
If \code{style = NULL}, the function will use global options
(see \code{setGlobalTableOptions()}) or an existing \verb{_brand.yml} file (if found);
otherwise, the default style is applied.
For more details, see the \emph{Styles} vignette on the package website.
}}

\item{showMinCellCount}{If \code{TRUE}, suppressed estimates will be indicated with
"<\{min_cell_count\}", otherwise, the default \code{na} defined in \code{.options} will be
used.}

\item{.options}{A named list with additional formatting options.
\code{visOmopResults::tableOptions()} shows allowed arguments and their default values.}
}
\value{
A formatted table of the class selected in "type" argument.
}
\description{
This function combines the functionalities of \code{formatEstimateValue()},
\code{estimateName()}, \code{formatHeader()}, and \code{formatTable()}
into a single function specifically for \verb{<summarised_result>} objects.
}
\examples{
result <- mockSummarisedResult()
result |>
  visOmopTable(
    estimateName = c("N\%" = "<count> (<percentage>)",
                     "N" = "<count>",
                     "Mean (SD)" = "<mean> (<sd>)"),
    header = c("cohort_name"),
    rename = c("Database name" = "cdm_name"),
    groupColumn = strataColumns(result)
  )
result |>
  visOmopTable(
    estimateName = c(
      "N\%" = "<count> (<percentage>)",
      "N" = "<count>",
      "Mean (SD)" = "<mean> (<sd>)"
    ),
    header = c("cohort_name"),
    rename = c("Database name" = "cdm_name"),
    groupColumn = strataColumns(result),
    type = "reactable"
  )

}
