% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/valid_vin_format.R
\name{valid_vin_format}
\alias{valid_vin_format}
\title{Check VIN Length and Characters}
\usage{
valid_vin_format(vin, check_chars = FALSE)
}
\arguments{
\item{vin}{A character. Should be a properly formatted Vehicle Identification Number.
Wildcards (e.g., '*') are acceptable.}

\item{check_chars}{Logical. Should an error be thrown if the VIN contains illegal characters?}
}
\value{
Logical.
}
\description{
Checks that VINs are 17 characters long and will optionally check that disallowed
characters (I, O, Q) are not present.
}
\examples{
# Random VIN
valid_vin_format("3VWLL7AJ9BM053541")
# With wild card
valid_vin_format("3VWLL7AJ9BM*53541")
}
