% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base-legends.R
\name{categoricalLegend}
\alias{categoricalLegend}
\title{Create a categorical legend}
\usage{
categoricalLegend(
  inputId,
  label = NULL,
  class = "",
  values = NULL,
  data = NULL,
  colors = NULL,
  palette = NULL,
  orient = "bottom",
  size = 220,
  multiple = TRUE
)
}
\arguments{
\item{inputId}{The \code{input} slot that will be used to access the value.}

\item{label}{Display label for the control, or \code{NULL} for no label.}

\item{class}{The CSS class of the input div element to match with any filter toggling functions. Default class is \code{"categorical-color-filter"}.}

\item{values}{List of character vectors that will match with the colors or palette in the order provided by both.}

\item{data}{Alternative vector to extract values with \code{"unique()"} function.}

\item{colors}{Colours to match with values; must be a valid argument to
\code{\link[grDevices:col2rgb]{grDevices::col2rgb()}}. This can be a character vector of
\code{"#RRGGBB"} or  \code{"#RRGGBBAA"}, colour names from
\code{\link[grDevices:colors]{grDevices::colors()}}, or a positive integer that indexes into
\code{\link[grDevices:palette]{grDevices::palette()}}.}

\item{palette}{A function that outputs a list of colors.}

\item{orient}{Orientation of the legend. Can be \code{"bottom"} (default, horizontal with labels below), \code{"top"} (horizontal with labels above), \code{"left"} (vertical with labels on the left)
and \code{"right"} (vertical with labels on the right).}

\item{size}{Absolute length in pixels of the color bar; becomes width or height depending on value of \code{orient}. Default is \code{220}.}

\item{multiple}{Is selection of multiple items allowed? Default is \code{TRUE}. With \code{FALSE}, selecting one item will de-select the others.}
}
\value{
A categorical color legend control that can be added to a UI definition
}
\description{
Create a color legend based on given data and palette or colors. Also passes on data- attributes for optional JS interaction.
}
\seealso{
\code{\link[=discreteColorFilter]{discreteColorFilter()}} \code{\link[=continuousColorFilter]{continuousColorFilter()}} \code{\link[=categoricalColorFilter]{categoricalColorFilter()}}

Other base legend: 
\code{\link{numericLegend}()}
}
\concept{base legend}
