% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/veg_starts.R
\name{method_Ribes}
\alias{method_Ribes}
\title{Vegetation Start Method "Ribes uva-crispa"}
\description{
The method \verb{Ribes uva-crispa} is based on leaf-out of gooseberry (Janssen 2009).
It was developed by the Germany's National Meteorological Service
(Deutscher Wetterdienst, DWD) and is more robust against early starts than
common simple meteorological procedures.
}
\section{Calculation}{


starting from 18th February sum all day degrees above 0 °C (daily average air
temperature). Vegetetaion period starts at the day when 164 is crossed.

\if{html}{\out{<div class="sourceCode">}}\preformatted{# start day: February 18th == 49 doy
# only Tavg over 0°C are summed
df[df$DOY < 49 | df$Tavg < 0, 'Tavg'] <- 0

# find day where cum day degrees cross 164
start <- tapply(df$Tavg, df$year, FUN=function(x)\{
  x <- cumsum(x)
  min(which(x > 164))
\})
}\if{html}{\out{</div>}}
}

\references{
Janssen, W. (2009)
Definition des Vegetationsanfanges.
\emph{Internal Report, Deutscher Wetterdienst, Abteilung Agrarmeteorologie}.
}
\keyword{internal}
