% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mark.r
\encoding{UTF-8}
\name{mark_bar}
\alias{mark_bar}
\title{Bar mark}
\usage{
mark_bar(vl, orient = NULL, stack = NULL, size = NULL, opacity = NULL,
  filled = NULL, color = NULL, fill = NULL, stroke = NULL)
}
\arguments{
\item{vl}{Vega-Lite object}

\item{orient}{the orientation of a non-stacked bar, area, and line charts.
The value is either "horizontal", or "vertical" (default). For bar and
tick, this determines whether the size of the bar and tick should be
applied to x or y dimension. For area, this property determines the
orient property of the Vega output. For line, this property determines
the path order of the points in the line if path channel is not specified.
For stacked charts, this is always determined by the orientation of the stack;
therefore explicitly specified value will be ignored.}

\item{stack}{stacking modes for bar and area marks. \code{zero} - stacking
with baseline offset at zero value of the scale (for creating typical stacked
bar and area chart). \code{normalize} - stacking with normalized domain (for
creating normalized stacked bar and area chart). \code{center} - stacking
with center baseline (for streamgraph). \code{none} - No-stacking. This will
produces layered bar and area chart.}

\item{size}{The pixel area each the point. For example: in the case of circles,
the radius is determined in part by the square root of the size value.}

\item{opacity}{\code{0.0}-\code{1.0}}

\item{filled}{whether the shape's color should be used as fill color instead of stroke color.}

\item{color}{color of the mark – either fill or stroke color based on the filled mark config.}

\item{fill}{fill color. This config will be overridden by color channel’s
specified or mapped values if filled is true.}

\item{stroke}{stroke color. This config will be overridden by color channel’s
specified or mapped values if filled is false.}
}
\description{
A bar mark represents each data point as a rectangle, where the length is
mapped to a quantitative scale.
}
\examples{
dat <- jsonlite::fromJSON('[
    {"a": "A","b": 28}, {"a": "B","b": 55}, {"a": "C","b": 43},
    {"a": "D","b": 91}, {"a": "E","b": 81}, {"a": "F","b": 53},
    {"a": "G","b": 19}, {"a": "H","b": 87}, {"a": "I","b": 52}
  ]')

vegalite() \%>\%
  add_data(dat) \%>\%
  encode_x("a", "ordinal") \%>\%
  encode_y("b", "quantitative") \%>\%
  mark_bar()
}
\references{
\href{http://vega.github.io/vega-lite/docs/mark.html}{Vega-Lite Mark spec}
}

