% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fromspec.r
\encoding{UTF-8}
\name{from_spec}
\alias{from_spec}
\title{Take a JSON Vega-Lite Spec and render as an htmlwidget}
\usage{
from_spec(spec, width = NULL, height = NULL, renderer = c("svg",
  "canvas"), export = FALSE, source = FALSE, editor = FALSE)
}
\arguments{
\item{spec}{URL to a Vega-Lite JSON file or the JSON text of a spec}

\item{width, height}{widget width/height}

\item{renderer}{the renderer to use for the view. One of \code{canvas} or
\code{svg} (the default)}

\item{export}{if \code{TRUE} the \emph{"Export as..."} link will
be displayed with the chart.(Default: \code{FALSE}.)}

\item{source}{if \code{TRUE} the \emph{"View Source"} link will be displayed
with the chart. (Default: \code{FALSE}.)}

\item{editor}{if \code{TRUE} the \emph{"Open in editor"} link will be
displayed with the cahrt. (Default: \code{FALSE}.)}
}
\description{
Vega-Lite is - at the core - a JSON "Grammar of Graphics" specification
for how to build a data- & stats-based visualization. While Vega & D3 are
the main targets, the use of Vega-Lite does not have to be restricted to just
D3. For now, this function takes in a JSON spec (full text or URL) and
renders it as an htmlwidget. Data should either be embedded or use a
an absolute URL reference.
}
\examples{
from_spec("http://rud.is/dl/embedded.json")
}

