% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/facet.r
\encoding{UTF-8}
\name{facet_col}
\alias{facet_col}
\title{Create a horizontal ribbon of panels}
\usage{
facet_col(vl, field, type, round = TRUE, padding = 16)
}
\arguments{
\item{vl}{Vega-Lite object}

\item{field}{single element character vector naming the column.}

\item{type}{the encoded field’s type of measurement.}

\item{round}{round values}

\item{padding}{facet padding}
}
\description{
Create a horizontal ribbon of panels
}
\examples{
vegalite() \%>\%
  add_data("https://vega.github.io/vega-editor/app/data/population.json") \%>\%
  add_filter("datum.year == 2000") \%>\%
  calculate("gender", 'datum.sex == 2 ? "Female" : "Male"') \%>\%
  encode_x("gender", "nominal") \%>\%
  encode_y("people", "quantitative", aggregate="sum") \%>\%
  encode_color("gender", "nominal") \%>\%
  scale_x_ordinal(band_size=6) \%>\%
  scale_color_nominal(range=c("#EA98D2", "#659CCA")) \%>\%
  facet_col("age", "ordinal", padding=4) \%>\%
  axis_x(remove=TRUE) \%>\%
  axis_y(title="population", grid=FALSE) \%>\%
  axis_facet_col(orient="bottom", axisWidth=1, offset=-8) \%>\%
  facet_cell(stroke_width=0) \%>\%
  mark_bar()
}
\references{
\href{http://vega.github.io/vega-lite/docs/facet.html}{Vega-Lite Faceting}
}

