% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform.r
\name{calculate}
\alias{calculate}
\title{Derive new fields}
\usage{
calculate(vl, field, expr)
}
\arguments{
\item{vl}{Vega-Lite object created by \code{\link{vegalite}}}

\item{field}{the field name in which to store the computed value.}

\item{expr}{a string containing an expression for the formula. Use the variable
\code{"datum"} to refer to the current data object.}
}
\description{
Derive new fields
}
\examples{
vegalite() \%>\%
  add_data("https://vega.github.io/vega-editor/app/data/population.json") \%>\%
  add_filter("datum.year == 2000") \%>\%
  calculate("gender", 'datum.sex == 2 ? "Female" : "Male"') \%>\%
  encode_x("gender", "nominal") \%>\%
  encode_y("people", "quantitative", aggregate="sum") \%>\%
  encode_color("gender", "nominal") \%>\%
  scale_x_ordinal(band_size=6) \%>\%
  scale_color_nominal(range=c("#EA98D2", "#659CCA")) \%>\%
  facet_col("age", "ordinal", padding=4) \%>\%
  axis_x(remove=TRUE) \%>\%
  axis_y(title="population", grid=FALSE) \%>\%
  axis_facet_col(orient="bottom", axisWidth=1, offset=-8) \%>\%
  facet_cell(stroke_width=0) \%>\%
  mark_bar()
}

