% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare.vectors.R
\name{compare.vectors}
\alias{compare.vectors}
\title{Compare all combinations of vectors using set operations}
\usage{
compare.vectors(named_list_of_vectors_to_compare,
  degrees_of_comparison_to_include = NULL, draw_venn_diagrams = FALSE,
  vector_colors_for_venn_diagrams = NULL, save_venn_diagram_files = FALSE,
  location_for_venn_diagram_files = "", prefix_for_venn_diagram_files = "",
  saved_venn_diagram_resolution_ppi = 300,
  saved_venn_diagram_dimension_units = "in", saved_venn_diagram_width = 8,
  saved_venn_diagram_height = 6, viewport_npc_width_height_for_images = 1,
  suppress_messages = FALSE)
}
\arguments{
\item{named_list_of_vectors_to_compare}{A named list of vectors to compare (see, for example, \code{\link{example.vectors.list}}). Duplicate values in a given vector will only be counted once (for example, c("a", "a", "b", "c") will be treated identically to c("a", "b", "c").}

\item{degrees_of_comparison_to_include}{A number or vector of numbers of which degrees of comparison to print (for example, 'c(2, 5)' would print only 2- and 5-way vector comparisons).}

\item{draw_venn_diagrams}{A logical (TRUE/FALSE) indicator whether to draw Venn diagrams for all 2- through 5-way comparisons of vectors.}

\item{vector_colors_for_venn_diagrams}{An optional vector of color names for Venn diagrams (if \code{draw_venn_diagrams} is \code{TRUE}). Color names are applied to the named vectors in \code{named_list_of_vectors_to_compare} in their order in \code{named_list_of_vectors_to_compare}. If this is blank, a random color will be selected for each vector. Either way, each vector will have a consistent color across the Venn diagrams in which it appears.}

\item{save_venn_diagram_files}{A logical (TRUE/FALSE) indicator whether to save Venn diagrams as PNG files.}

\item{location_for_venn_diagram_files}{An optional string giving a directory into which to save Venn diagram PNG files (if \code{save_venn_diagram_files} is \code{TRUE}). This location must already exist on the filesystem.}

\item{prefix_for_venn_diagram_files}{An optional string giving a prefix to prepend to saved Venn diagram PNG files (if \code{save_venn_diagram_files} is \code{TRUE}).}

\item{saved_venn_diagram_resolution_ppi}{An optional number giving a resolution (PPI) for saved Venn diagrams (if \code{save_venn_diagram_files} is \code{TRUE}).}

\item{saved_venn_diagram_dimension_units}{An optional string giving units for specifying \code{saved_venn_diagram_width} and \code{saved_venn_diagram_height} (if \code{save_venn_diagram_files} is \code{TRUE}). Can be \code{px} (pixels), \code{in} (inches, the default), \code{cm}, or \code{mm}.}

\item{saved_venn_diagram_width}{The width (in \code{saved_venn_diagram_dimension_units} units) for saved Venn diagrams (if \code{save_venn_diagram_files} is \code{TRUE}).}

\item{saved_venn_diagram_height}{The height (in \code{saved_venn_diagram_dimension_units} units) for saved Venn diagrams (if \code{save_venn_diagram_files} is \code{TRUE}).}

\item{viewport_npc_width_height_for_images}{The scale at which to print an image. If the image is cut off at its edges, for example, this can be set lower than 1.0.}

\item{suppress_messages}{A logical (TRUE/FALSE) indicator whether to suppress messages. Even if this is \code{TRUE}, warnings will still be printed.}
}
\value{
A list, with one object for each comparison of vectors. The list contains the following elements:
\describe{
  \item{elements_involved}{The vector names involved in the comparison.}
  \item{union_of_elements}{A vector of all (deduplicated) items involved in the comparison, across all of the vectors.}
  \item{overlap_of_elements}{A vector of the deduplicated elements that occurred in all of the compared vectors.}
  \item{elements_unique_to_first_element}{This element will have a sub-element named for each vector being compared (i.e., for each of the names in \code{$elements_involved}). The (deduplicated) items that were unique to that vector (i.e., not overlapping with any other vector in the comparison).}
  \item{venn_diagram}{If \code{save_venn_diagram_files} is \code{TRUE}, and the comparison is of 2 through 5 vectors, a Venn diagram object produced using the \pkg{VennDiagram} package. This diagram can be rendered using \code{\link{render.venn.diagram}}.}
}

To compile this list object into a Markdown report, use \code{\link{compare.vectors.and.return.text.analysis.of.overlap}}. For an example of this usage, see the \code{Veccompare Overlap Report} RMarkdown template for RStudio that is installed as part of the \pkg{veccompare} package.
}
\description{
Compare all combinations of vectors using set operations
}
\examples{
example <- veccompare::compare.vectors(veccompare::example.vectors.list)

# To extract similar elements across list items:
veccompare::extract.compared.vectors(
  example,
  elements_of_output = "elements_involved"
)

# To extract all comparisons that involve "vector_a":
veccompare::extract.compared.vectors(
  example,
  vector_names = "vector_a"
)

# To find all comparisons that were about "vector_a" and "vector_c":
veccompare::extract.compared.vectors(
  example,
  vector_names = c("vector_a", "vector_c"),
  only_match_vector_names = TRUE
)

# To get all elements that did a two-way comparison:
veccompare::extract.compared.vectors(
  example,
  degrees_of_comparison = 2
)
}
