% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_se.R
\name{se.cor}
\alias{se.cor}
\title{Computes the standard error for a Pearson or partial correlation}
\usage{
se.cor(cor, s, n)
}
\arguments{
\item{cor}{estimated Pearson or partial correlation}

\item{s}{number of control variables (set to 0 for Pearson)}

\item{n}{sample size}
}
\value{
Returns a one-row matrix:
\itemize{
\item Estimate - Pearson or partial correlation (from input)
\item SE - standard error
}
}
\description{
Computes the standard error of a  Pearson or partial correlation
using the estimated correlation, sample size, and number of
control variables. The correlation, along with the standard error
output from this function, can be used as input in the
\link[vcmeta]{meta.ave.cor.gen} function in applications where a
combination of different types of compatible correlations are
used in the meta-analysis.
}
\examples{
se.cor(.40, 0, 55)
#' # Should return: 
#               Estimate       SE
# Correlation:       0.4 0.116487


}
\references{
\insertRef{Bonett2008a}{vcmeta}
}
