% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scales.R
\name{scale-date}
\alias{scale-date}
\alias{v_scale_x_date}
\alias{v_scale_y_date}
\alias{v_scale_x_datetime}
\alias{v_scale_y_datetime}
\title{Axis scale for date/time data}
\usage{
v_scale_x_date(
  vc,
  name = NULL,
  date_breaks = NULL,
  date_labels = NULL,
  date_labels_tooltip = date_labels,
  min = NULL,
  max = NULL,
  ...,
  position = "bottom"
)

v_scale_y_date(
  vc,
  name = NULL,
  date_breaks = NULL,
  date_labels = NULL,
  date_labels_tooltip = date_labels,
  min = NULL,
  max = NULL,
  ...,
  position = "left"
)

v_scale_x_datetime(
  vc,
  name = NULL,
  date_breaks = NULL,
  date_labels = NULL,
  date_labels_tooltip = date_labels,
  tz = NULL,
  min = NULL,
  max = NULL,
  ...,
  position = "bottom"
)

v_scale_y_datetime(
  vc,
  name = NULL,
  date_breaks = NULL,
  date_labels = NULL,
  date_labels_tooltip = date_labels,
  tz = NULL,
  min = NULL,
  max = NULL,
  ...,
  position = "left"
)
}
\arguments{
\item{vc}{An htmlwidget created with \code{\link[=vchart]{vchart()}} or specific chart's type function.}

\item{name}{Title for the axis.}

\item{date_breaks}{One of:
\itemize{
\item A single \code{numeric} value giving the number of breaks.
\item A string giving the distance between breaks like "2 weeks", or "10 years".
\item A Date/POSIXct vector giving positions of breaks.
}}

\item{date_labels}{The format to be applied on Date/POSIXct in the labels, see \code{\link[=format_date_dayjs]{format_date_dayjs()}}.}

\item{date_labels_tooltip}{The format to be applied on Date/POSIXct in the tooltip, see \code{\link[=format_date_dayjs]{format_date_dayjs()}}.}

\item{min}{Minimum value on the axis.}

\item{max}{Maximum value on the axis.}

\item{...}{Additional parameters for the axis.}

\item{position}{Position of the axis.}

\item{tz}{The timezone.}
}
\value{
A \code{\link[=vchart]{vchart()}} \code{htmlwidget} object.
}
\description{
Axis scale for date/time data
}
\examples{

library(vchartr)

# Add a title to the axis
vchart(eco2mix) \%>\%
  v_line(aes(date, solar)) \%>\%
  v_scale_x_date(name = "Date")

# Specify number of labels
vchart(eco2mix) \%>\%
  v_line(aes(date, solar)) \%>\%
  v_scale_x_date(date_breaks = 5)

# Specify intervals between labels
vchart(eco2mix) \%>\%
  v_line(aes(date, solar)) \%>\%
  v_scale_x_date(date_breaks = "2 years")

# Format labels
vchart(eco2mix) \%>\%
  v_line(aes(date, solar)) \%>\%
  v_scale_x_date(date_labels = "MM-YYYY")

# Other format for labels
vchart(eco2mix) \%>\%
  v_line(aes(date, solar)) \%>\%
  v_scale_x_date(date_labels = "MMM YYYY")

# Format labels with locale
vchart(eco2mix) \%>\%
  v_line(aes(date, solar)) \%>\%
  v_scale_x_date(
    date_labels = format_date_dayjs("MMMM YY", locale = "fr")
  )

# Different formats in labels and tootlip
vchart(eco2mix) \%>\%
  v_line(aes(date, solar)) \%>\%
  v_scale_x_date(
    date_labels = "YYYY-MM",
    date_labels_tooltip = "MMMM YYYY"
  )

}
