% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{house}
\alias{house}
\title{Lucas County House Price Data}
\format{
A data frame with 25357 rows and 25 variables:
\describe{
  \item{price}{(\code{integer}) selling price, in US dollars}
  \item{yrbuilt}{(\code{integer}) year the house was built}
  \item{stories}{(\code{factor}) levels are \code{"one", "bilevel",
  "multilvl",  "one+half", "two", "two+half", "three"}}
  \item{TLA}{(\code{integer}) total living area, in square feet.}
  \item{wall}{(\code{factor}) levels are \code{"stucdrvt", "ccbtile",
  "metlvnyl", "brick", "stone", "wood", "partbrk"}}
  \item{beds, baths, halfbaths}{(\code{integer}) number of corresponding
  rooms / facilities.}
  \item{frontage, depth}{dimensions of the lot. Unit is feet.}
  \item{garage}{(\code{factor}) levels are \code{"no garage", "basement",
  "attached", "detached", "carport"}}
  \item{garagesqft}{(\code{integer}) garage area, in square feet. If
  \code{garage == "no garage"}, then \code{garagesqft == 0}.}
  \item{rooms}{(\code{integer}) number of rooms}
  \item{lotsize}{(\code{integer}) area of lot, in square feet}
  \item{sdate}{(\code{Date}) selling date, in format \code{yyyy-mm-dd}}
  \item{avalue}{(\code{int}) appraised value}
  \item{s1993, s1994, s1995, s1996, s1997, s1998}{(\code{int}) dummies for
  selling year.}
  \item{syear}{(\code{factor}) levels are selling years \code{"1993", "1994",
  "1995", "1996", "1997", "1998"}}
  \item{long, lat}{(\code{numeric}) location of houses. Longitude and
  Latitude are given in \code{CRS(+init=epsg:2834)}, the Ohio North State
  Plane. Units are meters.}
}
}
\source{
\url{http://www.spatial-econometrics.com/html/jplv6.zip}
}
\usage{
house
}
\description{
A dataset containing the prices and other attributes of 25,357 houses in
Lucas County, Ohio. The selling dates span years 1993 to 1998. Data taken
from \code{\link[spData]{house}} (\code{spData} package) and slightly modified to a \code{data.frame}.
}
\keyword{datasets}
